# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from capif_security.models.base_model_ import Model
from capif_security import util


class AccessTokenClaims(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, iss=None, scope=None, exp=None):  # noqa: E501
        """AccessTokenClaims - a model defined in OpenAPI

        :param iss: The iss of this AccessTokenClaims.  # noqa: E501
        :type iss: str
        :param scope: The scope of this AccessTokenClaims.  # noqa: E501
        :type scope: str
        :param exp: The exp of this AccessTokenClaims.  # noqa: E501
        :type exp: int
        """
        self.openapi_types = {
            'iss': str,
            'scope': str,
            'exp': int
        }

        self.attribute_map = {
            'iss': 'iss',
            'scope': 'scope',
            'exp': 'exp'
        }

        self._iss = iss
        self._scope = scope
        self._exp = exp

    @classmethod
    def from_dict(cls, dikt) -> 'AccessTokenClaims':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The AccessTokenClaims of this AccessTokenClaims.  # noqa: E501
        :rtype: AccessTokenClaims
        """
        return util.deserialize_model(dikt, cls)

    @property
    def iss(self):
        """Gets the iss of this AccessTokenClaims.


        :return: The iss of this AccessTokenClaims.
        :rtype: str
        """
        return self._iss

    @iss.setter
    def iss(self, iss):
        """Sets the iss of this AccessTokenClaims.


        :param iss: The iss of this AccessTokenClaims.
        :type iss: str
        """
        if iss is None:
            raise ValueError("Invalid value for `iss`, must not be `None`")  # noqa: E501

        self._iss = iss

    @property
    def scope(self):
        """Gets the scope of this AccessTokenClaims.


        :return: The scope of this AccessTokenClaims.
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """Sets the scope of this AccessTokenClaims.


        :param scope: The scope of this AccessTokenClaims.
        :type scope: str
        """
        if scope is None:
            raise ValueError("Invalid value for `scope`, must not be `None`")  # noqa: E501

        self._scope = scope

    @property
    def exp(self):
        """Gets the exp of this AccessTokenClaims.

        Unsigned integer identifying a period of time in units of seconds.  # noqa: E501

        :return: The exp of this AccessTokenClaims.
        :rtype: int
        """
        return self._exp

    @exp.setter
    def exp(self, exp):
        """Sets the exp of this AccessTokenClaims.

        Unsigned integer identifying a period of time in units of seconds.  # noqa: E501

        :param exp: The exp of this AccessTokenClaims.
        :type exp: int
        """
        if exp is None:
            raise ValueError("Invalid value for `exp`, must not be `None`")  # noqa: E501
        if exp is not None and exp < 0:  # noqa: E501
            raise ValueError("Invalid value for `exp`, must be a value greater than or equal to `0`")  # noqa: E501

        self._exp = exp
