# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from capif_routing_info.models.base_model_ import Model
from capif_routing_info import util


class Ipv6AddressRange(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, start=None, end=None):  # noqa: E501
        """Ipv6AddressRange - a model defined in OpenAPI

        :param start: The start of this Ipv6AddressRange.  # noqa: E501
        :type start: str
        :param end: The end of this Ipv6AddressRange.  # noqa: E501
        :type end: str
        """
        self.openapi_types = {
            'start': str,
            'end': str
        }

        self.attribute_map = {
            'start': 'start',
            'end': 'end'
        }

        self._start = start
        self._end = end

    @classmethod
    def from_dict(cls, dikt) -> 'Ipv6AddressRange':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Ipv6AddressRange of this Ipv6AddressRange.  # noqa: E501
        :rtype: Ipv6AddressRange
        """
        return util.deserialize_model(dikt, cls)

    @property
    def start(self):
        """Gets the start of this Ipv6AddressRange.

        string identifying a Ipv6 address formatted according to clause 4 in IETF RFC 5952. The mixed Ipv4 Ipv6 notation according to clause 5 of IETF RFC 5952 shall not be used.  # noqa: E501

        :return: The start of this Ipv6AddressRange.
        :rtype: str
        """
        return self._start

    @start.setter
    def start(self, start):
        """Sets the start of this Ipv6AddressRange.

        string identifying a Ipv6 address formatted according to clause 4 in IETF RFC 5952. The mixed Ipv4 Ipv6 notation according to clause 5 of IETF RFC 5952 shall not be used.  # noqa: E501

        :param start: The start of this Ipv6AddressRange.
        :type start: str
        """
        if start is None:
            raise ValueError("Invalid value for `start`, must not be `None`")  # noqa: E501

        self._start = start

    @property
    def end(self):
        """Gets the end of this Ipv6AddressRange.

        string identifying a Ipv6 address formatted according to clause 4 in IETF RFC 5952. The mixed Ipv4 Ipv6 notation according to clause 5 of IETF RFC 5952 shall not be used.  # noqa: E501

        :return: The end of this Ipv6AddressRange.
        :rtype: str
        """
        return self._end

    @end.setter
    def end(self, end):
        """Sets the end of this Ipv6AddressRange.

        string identifying a Ipv6 address formatted according to clause 4 in IETF RFC 5952. The mixed Ipv4 Ipv6 notation according to clause 5 of IETF RFC 5952 shall not be used.  # noqa: E501

        :param end: The end of this Ipv6AddressRange.
        :type end: str
        """
        if end is None:
            raise ValueError("Invalid value for `end`, must not be `None`")  # noqa: E501

        self._end = end
