# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from capif_events.models.base_model_ import Model
import re
from capif_events import util

import re  # noqa: E501

class Ipv4AddressRange(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, start=None, end=None):  # noqa: E501
        """Ipv4AddressRange - a model defined in OpenAPI

        :param start: The start of this Ipv4AddressRange.  # noqa: E501
        :type start: str
        :param end: The end of this Ipv4AddressRange.  # noqa: E501
        :type end: str
        """
        self.openapi_types = {
            'start': str,
            'end': str
        }

        self.attribute_map = {
            'start': 'start',
            'end': 'end'
        }

        self._start = start
        self._end = end

    @classmethod
    def from_dict(cls, dikt) -> 'Ipv4AddressRange':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Ipv4AddressRange of this Ipv4AddressRange.  # noqa: E501
        :rtype: Ipv4AddressRange
        """
        return util.deserialize_model(dikt, cls)

    @property
    def start(self):
        """Gets the start of this Ipv4AddressRange.

        String identifying a IPv4 address formatted in the \"dotted decimal\" notation as defined in RFC 1166.  # noqa: E501

        :return: The start of this Ipv4AddressRange.
        :rtype: str
        """
        return self._start

    @start.setter
    def start(self, start):
        """Sets the start of this Ipv4AddressRange.

        String identifying a IPv4 address formatted in the \"dotted decimal\" notation as defined in RFC 1166.  # noqa: E501

        :param start: The start of this Ipv4AddressRange.
        :type start: str
        """
        if start is not None and not re.search(r'^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$', start):  # noqa: E501
            raise ValueError("Invalid value for `start`, must be a follow pattern or equal to `/^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$/`")  # noqa: E501

        self._start = start

    @property
    def end(self):
        """Gets the end of this Ipv4AddressRange.

        String identifying a IPv4 address formatted in the \"dotted decimal\" notation as defined in RFC 1166.  # noqa: E501

        :return: The end of this Ipv4AddressRange.
        :rtype: str
        """
        return self._end

    @end.setter
    def end(self, end):
        """Sets the end of this Ipv4AddressRange.

        String identifying a IPv4 address formatted in the \"dotted decimal\" notation as defined in RFC 1166.  # noqa: E501

        :param end: The end of this Ipv4AddressRange.
        :type end: str
        """
        if end is not None and not re.search(r'^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$', end):  # noqa: E501
            raise ValueError("Invalid value for `end`, must be a follow pattern or equal to `/^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$/`")  # noqa: E501

        self._end = end
