# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from api_provider_management.models.base_model_ import Model
from api_provider_management.models.api_provider_func_role import ApiProviderFuncRole
from api_provider_management.models.registration_information import RegistrationInformation
from api_provider_management import util

from api_provider_management.models.api_provider_func_role import ApiProviderFuncRole  # noqa: E501
from api_provider_management.models.registration_information import RegistrationInformation  # noqa: E501

class APIProviderFunctionDetails(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, api_prov_func_id=None, reg_info=None, api_prov_func_role=None, api_prov_func_info=None):  # noqa: E501
        """APIProviderFunctionDetails - a model defined in OpenAPI

        :param api_prov_func_id: The api_prov_func_id of this APIProviderFunctionDetails.  # noqa: E501
        :type api_prov_func_id: str
        :param reg_info: The reg_info of this APIProviderFunctionDetails.  # noqa: E501
        :type reg_info: RegistrationInformation
        :param api_prov_func_role: The api_prov_func_role of this APIProviderFunctionDetails.  # noqa: E501
        :type api_prov_func_role: ApiProviderFuncRole
        :param api_prov_func_info: The api_prov_func_info of this APIProviderFunctionDetails.  # noqa: E501
        :type api_prov_func_info: str
        """
        self.openapi_types = {
            'api_prov_func_id': str,
            'reg_info': RegistrationInformation,
            'api_prov_func_role': ApiProviderFuncRole,
            'api_prov_func_info': str
        }

        self.attribute_map = {
            'api_prov_func_id': 'apiProvFuncId',
            'reg_info': 'regInfo',
            'api_prov_func_role': 'apiProvFuncRole',
            'api_prov_func_info': 'apiProvFuncInfo'
        }

        self._api_prov_func_id = api_prov_func_id
        self._reg_info = reg_info
        self._api_prov_func_role = api_prov_func_role
        self._api_prov_func_info = api_prov_func_info

    @classmethod
    def from_dict(cls, dikt) -> 'APIProviderFunctionDetails':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The APIProviderFunctionDetails of this APIProviderFunctionDetails.  # noqa: E501
        :rtype: APIProviderFunctionDetails
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api_prov_func_id(self):
        """Gets the api_prov_func_id of this APIProviderFunctionDetails.

        API provider domain functionID assigned by the CAPIF core function to the API provider domain function while registering/updating the API provider domain. Shall not be present in the HTTP POST request from the API management function to the CAPIF core function, to register itself. Shall be present in all other HTTP requests and responses.   # noqa: E501

        :return: The api_prov_func_id of this APIProviderFunctionDetails.
        :rtype: str
        """
        return self._api_prov_func_id

    @api_prov_func_id.setter
    def api_prov_func_id(self, api_prov_func_id):
        """Sets the api_prov_func_id of this APIProviderFunctionDetails.

        API provider domain functionID assigned by the CAPIF core function to the API provider domain function while registering/updating the API provider domain. Shall not be present in the HTTP POST request from the API management function to the CAPIF core function, to register itself. Shall be present in all other HTTP requests and responses.   # noqa: E501

        :param api_prov_func_id: The api_prov_func_id of this APIProviderFunctionDetails.
        :type api_prov_func_id: str
        """

        self._api_prov_func_id = api_prov_func_id

    @property
    def reg_info(self):
        """Gets the reg_info of this APIProviderFunctionDetails.


        :return: The reg_info of this APIProviderFunctionDetails.
        :rtype: RegistrationInformation
        """
        return self._reg_info

    @reg_info.setter
    def reg_info(self, reg_info):
        """Sets the reg_info of this APIProviderFunctionDetails.


        :param reg_info: The reg_info of this APIProviderFunctionDetails.
        :type reg_info: RegistrationInformation
        """
        if reg_info is None:
            raise ValueError("Invalid value for `reg_info`, must not be `None`")  # noqa: E501

        self._reg_info = reg_info

    @property
    def api_prov_func_role(self):
        """Gets the api_prov_func_role of this APIProviderFunctionDetails.


        :return: The api_prov_func_role of this APIProviderFunctionDetails.
        :rtype: ApiProviderFuncRole
        """
        return self._api_prov_func_role

    @api_prov_func_role.setter
    def api_prov_func_role(self, api_prov_func_role):
        """Sets the api_prov_func_role of this APIProviderFunctionDetails.


        :param api_prov_func_role: The api_prov_func_role of this APIProviderFunctionDetails.
        :type api_prov_func_role: ApiProviderFuncRole
        """
        if api_prov_func_role is None:
            raise ValueError("Invalid value for `api_prov_func_role`, must not be `None`")  # noqa: E501

        self._api_prov_func_role = api_prov_func_role

    @property
    def api_prov_func_info(self):
        """Gets the api_prov_func_info of this APIProviderFunctionDetails.

        Generic information related to the API provider domain function such as details of the API provider applications.   # noqa: E501

        :return: The api_prov_func_info of this APIProviderFunctionDetails.
        :rtype: str
        """
        return self._api_prov_func_info

    @api_prov_func_info.setter
    def api_prov_func_info(self, api_prov_func_info):
        """Sets the api_prov_func_info of this APIProviderFunctionDetails.

        Generic information related to the API provider domain function such as details of the API provider applications.   # noqa: E501

        :param api_prov_func_info: The api_prov_func_info of this APIProviderFunctionDetails.
        :type api_prov_func_info: str
        """

        self._api_prov_func_info = api_prov_func_info
