def create_service_api_description(api_name="service_1", aef_id="aef_id", supported_features="0", vendor_specific_service_api_description=None, vendor_specific_aef_profile=None):
    body = {
        "apiName": api_name,
        "aefProfiles": [
            {
                "aefId": aef_id,
                "versions": [
                    {
                        "apiVersion": "v1",
                        "expiry": "2021-11-30T10:32:02.004000+00:00",
                        "resources": [
                            {
                                "resourceName": "string",
                                "commType": "REQUEST_RESPONSE",
                                "uri": "string",
                                "custOpName": "string",
                                "operations": [
                                    "GET"
                                ],
                                "description": "string"
                            }
                        ],
                    }
                ],
                "protocol": "HTTP_1_1",
                "dataFormat": "JSON",
                "securityMethods": ["PSK"],
                "interfaceDescriptions": [
                    {
                        "ipv4Addr": "string",
                        "port": 65535,
                        "securityMethods": ["PSK"]
                    }
                ]
            }
        ],
        "description": "ROBOT_TESTING",
        "shareableInfo": {
            "isShareable": True,
            "capifProvDoms": [
                "string"
            ]
        },
        "serviceAPICategory": "string",
        "apiSuppFeats": "fffff",
        "pubApiPath": {
            "ccfIds": [
                "string"
            ]
        },
        "ccfId": "string"
    }

    if vendor_specific_service_api_description is not None:
        if isinstance(vendor_specific_service_api_description, dict):
            for key, value in vendor_specific_service_api_description.items():
                body[key] = value
    if vendor_specific_aef_profile is not None:
        if isinstance(vendor_specific_aef_profile, dict):
            for key, value in vendor_specific_aef_profile.items():
                body["aefProfiles"][0][key] = value
    if supported_features is not None:
        body['supportedFeatures'] = supported_features

    return body
