#!/bin/bash
export CAPIF_PRIV_KEY=
export CAPIF_PRIV_KEY_BASE_64=
export MONITORING=
export LOG_LEVEL=DEBUG

running="$(LOG_LEVEL=$LOG_LEVEL docker compose -f docker-compose-vault.yml ps --services --all --filter "status=running")"
services="$(LOG_LEVEL=$LOG_LEVEL docker compose -f docker-compose-vault.yml ps --services --all)"
if [ "$running" != "$services" ]; then
    echo "Following Vault services are not running:"
    # Bash specific
    comm -13 <(sort <<<"$running") <(sort <<<"$services")
    exit 1
else
    echo "All Vault services are running"
fi

running="$(LOG_LEVEL=$LOG_LEVEL docker compose -f docker-compose-capif.yml ps --services --all --filter "status=running")"
services="$(LOG_LEVEL=$LOG_LEVEL docker compose -f docker-compose-capif.yml ps --services --all)"
if [ "$running" != "$services" ]; then
    echo "Following CCF services are not running:"
    # Bash specific
    comm -13 <(sort <<<"$running") <(sort <<<"$services")
    exit 1
else
    echo "All CCF services are running"
fi

running="$(LOG_LEVEL=$LOG_LEVEL docker compose -f docker-compose-register.yml ps --services --all --filter "status=running")"
services="$(LOG_LEVEL=$LOG_LEVEL docker compose -f docker-compose-register.yml ps --services --all)"
if [ "$running" != "$services" ]; then
    echo "Following Register services are not running:"
    # Bash specific
    comm -13 <(sort <<<"$running") <(sort <<<"$services")
    exit 1
else
    echo "All Register services are running"
fi

exit 0
