from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from published_apis.models.base_model import Model
from published_apis import util


class UncertaintyEllipsoid(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, semi_major=None, semi_minor=None, vertical=None, orientation_major=None):  # noqa: E501
        """UncertaintyEllipsoid - a model defined in OpenAPI

        :param semi_major: The semi_major of this UncertaintyEllipsoid.  # noqa: E501
        :type semi_major: float
        :param semi_minor: The semi_minor of this UncertaintyEllipsoid.  # noqa: E501
        :type semi_minor: float
        :param vertical: The vertical of this UncertaintyEllipsoid.  # noqa: E501
        :type vertical: float
        :param orientation_major: The orientation_major of this UncertaintyEllipsoid.  # noqa: E501
        :type orientation_major: int
        """
        self.openapi_types = {
            'semi_major': float,
            'semi_minor': float,
            'vertical': float,
            'orientation_major': int
        }

        self.attribute_map = {
            'semi_major': 'semiMajor',
            'semi_minor': 'semiMinor',
            'vertical': 'vertical',
            'orientation_major': 'orientationMajor'
        }

        self._semi_major = semi_major
        self._semi_minor = semi_minor
        self._vertical = vertical
        self._orientation_major = orientation_major

    @classmethod
    def from_dict(cls, dikt) -> 'UncertaintyEllipsoid':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The UncertaintyEllipsoid of this UncertaintyEllipsoid.  # noqa: E501
        :rtype: UncertaintyEllipsoid
        """
        return util.deserialize_model(dikt, cls)

    @property
    def semi_major(self) -> float:
        """Gets the semi_major of this UncertaintyEllipsoid.

        Indicates value of uncertainty.  # noqa: E501

        :return: The semi_major of this UncertaintyEllipsoid.
        :rtype: float
        """
        return self._semi_major

    @semi_major.setter
    def semi_major(self, semi_major: float):
        """Sets the semi_major of this UncertaintyEllipsoid.

        Indicates value of uncertainty.  # noqa: E501

        :param semi_major: The semi_major of this UncertaintyEllipsoid.
        :type semi_major: float
        """
        if semi_major is None:
            raise ValueError("Invalid value for `semi_major`, must not be `None`")  # noqa: E501
        if semi_major is not None and semi_major < 0:  # noqa: E501
            raise ValueError("Invalid value for `semi_major`, must be a value greater than or equal to `0`")  # noqa: E501

        self._semi_major = semi_major

    @property
    def semi_minor(self) -> float:
        """Gets the semi_minor of this UncertaintyEllipsoid.

        Indicates value of uncertainty.  # noqa: E501

        :return: The semi_minor of this UncertaintyEllipsoid.
        :rtype: float
        """
        return self._semi_minor

    @semi_minor.setter
    def semi_minor(self, semi_minor: float):
        """Sets the semi_minor of this UncertaintyEllipsoid.

        Indicates value of uncertainty.  # noqa: E501

        :param semi_minor: The semi_minor of this UncertaintyEllipsoid.
        :type semi_minor: float
        """
        if semi_minor is None:
            raise ValueError("Invalid value for `semi_minor`, must not be `None`")  # noqa: E501
        if semi_minor is not None and semi_minor < 0:  # noqa: E501
            raise ValueError("Invalid value for `semi_minor`, must be a value greater than or equal to `0`")  # noqa: E501

        self._semi_minor = semi_minor

    @property
    def vertical(self) -> float:
        """Gets the vertical of this UncertaintyEllipsoid.

        Indicates value of uncertainty.  # noqa: E501

        :return: The vertical of this UncertaintyEllipsoid.
        :rtype: float
        """
        return self._vertical

    @vertical.setter
    def vertical(self, vertical: float):
        """Sets the vertical of this UncertaintyEllipsoid.

        Indicates value of uncertainty.  # noqa: E501

        :param vertical: The vertical of this UncertaintyEllipsoid.
        :type vertical: float
        """
        if vertical is None:
            raise ValueError("Invalid value for `vertical`, must not be `None`")  # noqa: E501
        if vertical is not None and vertical < 0:  # noqa: E501
            raise ValueError("Invalid value for `vertical`, must be a value greater than or equal to `0`")  # noqa: E501

        self._vertical = vertical

    @property
    def orientation_major(self) -> int:
        """Gets the orientation_major of this UncertaintyEllipsoid.

        Indicates value of orientation angle.  # noqa: E501

        :return: The orientation_major of this UncertaintyEllipsoid.
        :rtype: int
        """
        return self._orientation_major

    @orientation_major.setter
    def orientation_major(self, orientation_major: int):
        """Sets the orientation_major of this UncertaintyEllipsoid.

        Indicates value of orientation angle.  # noqa: E501

        :param orientation_major: The orientation_major of this UncertaintyEllipsoid.
        :type orientation_major: int
        """
        if orientation_major is None:
            raise ValueError("Invalid value for `orientation_major`, must not be `None`")  # noqa: E501
        if orientation_major is not None and orientation_major > 180:  # noqa: E501
            raise ValueError("Invalid value for `orientation_major`, must be a value less than or equal to `180`")  # noqa: E501
        if orientation_major is not None and orientation_major < 0:  # noqa: E501
            raise ValueError("Invalid value for `orientation_major`, must be a value greater than or equal to `0`")  # noqa: E501

        self._orientation_major = orientation_major
