# Install vault
```
$ helm repo add hashicorp https://helm.releases.hashicorp.com
$ helm upgrade --install vault hashicorp/vault -n mon --set server.standalone.enabled=true --create-namespace

# if you are using ingress controller, please use:
$ helm upgrade --install vault hashicorp/vault -n mon --set server.ingress.enabled=true --set server.ingress.hosts[0].host="vault.mon.int" --set server.ingress.ingressClassName=nginx --set server.standalone.enabled=true --create-namespace

# verify pods are running
$ kubectl -n mon get pods

```
NOTA: If using ingressRoute. Please, create a file with:

```
---

apiVersion: traefik.containo.us/v1alpha1 
kind: IngressRoute
metadata:
  name: vault-ingress-route 
  namespace: mon
spec:
  entryPoints: [web] 
  routes:
    - kind: Rule
      match: Host(`vault.mon.int`)
      services:
        - kind: Service
          name: vault-internal 
          port: 8200
          scheme: http

```
```
# deploy ingress route

$ kubectl apply -f ingress-route.yaml
```
# Creating vault PKI and certificates

## Considerations:
  - If you change values by default in the `capi/values.yaml`. Please, consider have a look of some topics:
    - You will need to create PKI and certificates, therefore. The `VAULT_TOKEN` provided must have sufficient permissions in Vault to create it
    - Modify:
      - `namespace` in `vault-job/vault-job.yaml`. The namespace should be changed in the entire file. By default is `mon` (same namespace when capif is deployed)
      - `export VAULT_ADDR` using the service deployed to vault. By default is `http://vault-internal:8200`
      - `export VAULT_TOKEN` using the token created to vault. By default is `dev-only-token`
      - `DOMAIN1` - variable used for generate certificate (CSR) to capif `(ex: DOMAIN1=capif.mobile.cloud)`.
```
$ kubectl apply -f vault-job/
```