from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from capif_security.models.base_model import Model
from capif_security.models.security_information import SecurityInformation
from capif_security.models.websock_notif_config import WebsockNotifConfig
import re
from capif_security import util

from capif_security.models.security_information import SecurityInformation  # noqa: E501
from capif_security.models.websock_notif_config import WebsockNotifConfig  # noqa: E501
import re  # noqa: E501

class ServiceSecurity(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, security_info=None, notification_destination=None, request_test_notification=None, websock_notif_config=None, supported_features=None):  # noqa: E501
        """ServiceSecurity - a model defined in OpenAPI

        :param security_info: The security_info of this ServiceSecurity.  # noqa: E501
        :type security_info: List[SecurityInformation]
        :param notification_destination: The notification_destination of this ServiceSecurity.  # noqa: E501
        :type notification_destination: str
        :param request_test_notification: The request_test_notification of this ServiceSecurity.  # noqa: E501
        :type request_test_notification: bool
        :param websock_notif_config: The websock_notif_config of this ServiceSecurity.  # noqa: E501
        :type websock_notif_config: WebsockNotifConfig
        :param supported_features: The supported_features of this ServiceSecurity.  # noqa: E501
        :type supported_features: str
        """
        self.openapi_types = {
            'security_info': List[SecurityInformation],
            'notification_destination': str,
            'request_test_notification': bool,
            'websock_notif_config': WebsockNotifConfig,
            'supported_features': str
        }

        self.attribute_map = {
            'security_info': 'securityInfo',
            'notification_destination': 'notificationDestination',
            'request_test_notification': 'requestTestNotification',
            'websock_notif_config': 'websockNotifConfig',
            'supported_features': 'supportedFeatures'
        }

        self._security_info = security_info
        self._notification_destination = notification_destination
        self._request_test_notification = request_test_notification
        self._websock_notif_config = websock_notif_config
        self._supported_features = supported_features

    @classmethod
    def from_dict(cls, dikt) -> 'ServiceSecurity':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ServiceSecurity of this ServiceSecurity.  # noqa: E501
        :rtype: ServiceSecurity
        """
        return util.deserialize_model(dikt, cls)

    @property
    def security_info(self) -> List[SecurityInformation]:
        """Gets the security_info of this ServiceSecurity.


        :return: The security_info of this ServiceSecurity.
        :rtype: List[SecurityInformation]
        """
        return self._security_info

    @security_info.setter
    def security_info(self, security_info: List[SecurityInformation]):
        """Sets the security_info of this ServiceSecurity.


        :param security_info: The security_info of this ServiceSecurity.
        :type security_info: List[SecurityInformation]
        """
        if security_info is None:
            raise ValueError("Invalid value for `security_info`, must not be `None`")  # noqa: E501

        self._security_info = security_info

    @property
    def notification_destination(self) -> str:
        """Gets the notification_destination of this ServiceSecurity.

        string providing an URI formatted according to IETF RFC 3986.  # noqa: E501

        :return: The notification_destination of this ServiceSecurity.
        :rtype: str
        """
        return self._notification_destination

    @notification_destination.setter
    def notification_destination(self, notification_destination: str):
        """Sets the notification_destination of this ServiceSecurity.

        string providing an URI formatted according to IETF RFC 3986.  # noqa: E501

        :param notification_destination: The notification_destination of this ServiceSecurity.
        :type notification_destination: str
        """
        if notification_destination is None:
            raise ValueError("Invalid value for `notification_destination`, must not be `None`")  # noqa: E501

        self._notification_destination = notification_destination

    @property
    def request_test_notification(self) -> bool:
        """Gets the request_test_notification of this ServiceSecurity.

        Set to true by API invoker to request the CAPIF core function to send a test notification as defined in in clause 7.6. Set to false or omitted otherwise.   # noqa: E501

        :return: The request_test_notification of this ServiceSecurity.
        :rtype: bool
        """
        return self._request_test_notification

    @request_test_notification.setter
    def request_test_notification(self, request_test_notification: bool):
        """Sets the request_test_notification of this ServiceSecurity.

        Set to true by API invoker to request the CAPIF core function to send a test notification as defined in in clause 7.6. Set to false or omitted otherwise.   # noqa: E501

        :param request_test_notification: The request_test_notification of this ServiceSecurity.
        :type request_test_notification: bool
        """

        self._request_test_notification = request_test_notification

    @property
    def websock_notif_config(self) -> WebsockNotifConfig:
        """Gets the websock_notif_config of this ServiceSecurity.


        :return: The websock_notif_config of this ServiceSecurity.
        :rtype: WebsockNotifConfig
        """
        return self._websock_notif_config

    @websock_notif_config.setter
    def websock_notif_config(self, websock_notif_config: WebsockNotifConfig):
        """Sets the websock_notif_config of this ServiceSecurity.


        :param websock_notif_config: The websock_notif_config of this ServiceSecurity.
        :type websock_notif_config: WebsockNotifConfig
        """

        self._websock_notif_config = websock_notif_config

    @property
    def supported_features(self) -> str:
        """Gets the supported_features of this ServiceSecurity.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :return: The supported_features of this ServiceSecurity.
        :rtype: str
        """
        return self._supported_features

    @supported_features.setter
    def supported_features(self, supported_features: str):
        """Sets the supported_features of this ServiceSecurity.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :param supported_features: The supported_features of this ServiceSecurity.
        :type supported_features: str
        """
        if supported_features is not None and not re.search(r'^[A-Fa-f0-9]*$', supported_features):  # noqa: E501
            raise ValueError("Invalid value for `supported_features`, must be a follow pattern or equal to `/^[A-Fa-f0-9]*$/`")  # noqa: E501

        self._supported_features = supported_features
