#!/usr/bin/env python3

from config import Config
from core.helper_operations import HelperOperations
from flask import Blueprint, request, current_app, jsonify

config = Config().get_config()

helper_routes = Blueprint("helper_routes", __name__)
helper_operation = HelperOperations()

@helper_routes.route("/helper/getInvokers", methods=["GET"])
def getInvokers():
    uuid = request.args.get('uuid')
    invoker_id = request.args.get('api_invoker_id')
    page_size = request.args.get('page_size')
    page = request.args.get('page')
    sort_order = request.args.get('sort_order')
    if page_size:
        page_size = int(page_size)
        if page_size < 0:
            return jsonify(message="The value of the page_size parameter must be greater than 0"), 400
    if page:
        page = int(page)
        if page < 0:
            return jsonify(message="The value of the page parameter must be greater than 0"), 400
    
    current_app.logger.debug(f"uuid: {uuid}, invoker_id: {invoker_id}, page: {page}, page_size: {page_size}, sort_order: {sort_order}")

    return helper_operation.get_invokers(uuid, invoker_id, page, page_size, sort_order)

@helper_routes.route("/helper/getProviders", methods=["GET"])
def getProviders():
    uuid = request.args.get('uuid')
    provider_id = request.args.get('api_prov_dom_id')
    page_size = request.args.get('page_size')
    page = request.args.get('page')
    sort_order = request.args.get('sort_order')

    if page_size:
        page_size = int(page_size)
        if page_size < 0:
            return jsonify(message="The value of the page_size parameter must be greater than 0"), 400
    if page:
        page = int(page)
        if page < 0:
            return jsonify(message="The value of the page parameter must be greater than 0"), 400
    
    current_app.logger.debug(f"uuid: {uuid}, provider_id: {provider_id}, page: {page}, page_size: {page_size}, sort_order: {sort_order}")

    return helper_operation.get_providers(uuid, provider_id, page, page_size, sort_order)


@helper_routes.route("/helper/getServices", methods=["GET"])
def getServices():
    service_id = request.args.get('service_id')
    apf_id = request.args.get('apf_id')
    api_name = request.args.get('api_name')
    page_size = request.args.get('page_size')
    page = request.args.get('page')
    sort_order = request.args.get('sort_order')
    if page_size:
        page_size = int(page_size)
        if page_size < 0:
            return jsonify(message="The value of the page_size parameter must be greater than 0"), 400
    if page:
        page = int(page)
        if page < 0:
            return jsonify(message="The value of the page parameter must be greater than 0"), 400
    
    current_app.logger.debug(f"service_id: {service_id}, apf_id: {apf_id}, api_name: {api_name}, page: {page}, page_size: {page_size}, sort_order: {sort_order}")

    return helper_operation.get_services(service_id, apf_id, api_name, page, page_size, sort_order)

@helper_routes.route("/helper/getSecurity", methods=["GET"])
def getSecurity():
    invoker_id = request.args.get('invoker_id')
    page_size = request.args.get('page_size')
    page = request.args.get('page')
    if page_size:
        page_size = int(page_size)
        if page_size < 0:
            return jsonify(message="The value of the page_size parameter must be greater than 0"), 400
    if page:
        page = int(page)
        if page < 0:
            return jsonify(message="The value of the page parameter must be greater than 0"), 400
    
    current_app.logger.debug(f"invoker_id: {invoker_id}, page: {page}, page_size: {page_size} ")

    return helper_operation.get_security(invoker_id, page, page_size)

@helper_routes.route("/helper/getEvents", methods=["GET"])
def getEvents():
    subscriber_id = request.args.get('subscriber_id')
    subscription_id = request.args.get('subscription_id')
    page_size = request.args.get('page_size')
    page = request.args.get('page')
    if page_size:
        page_size = int(page_size)
        if page_size < 0:
            return jsonify(message="The value of the page_size parameter must be greater than 0"), 400
    if page:
        page = int(page)
        if page < 0:
            return jsonify(message="The value of the page parameter must be greater than 0"), 400
    
    current_app.logger.debug(f"subscriber_id: {subscriber_id}, subscription_id: {subscription_id}, page: {page}, page_size: {page_size} ")

    return helper_operation.get_events(subscriber_id, subscription_id, page, page_size)


@helper_routes.route("/helper/deleteEntities/<uuid>", methods=["DELETE"])
def deleteUserEntities(uuid):
    return helper_operation.remove_entities(uuid)


@helper_routes.route("/helper/getConfiguration", methods=["GET"])
def getConfiguration():
    """Returns the current configuration"""
    return helper_operation.get_configuration()


@helper_routes.route("/helper/updateConfigParam", methods=["PATCH"])
def updateConfigParam():
    """Updates a single configuration parameter"""
    data = request.json
    param_path = data.get("param_path")
    new_value = data.get("new_value")

    if not param_path or new_value is None:
        return jsonify(message="Missing 'param_path' or 'new_value' in request body"), 400

    return helper_operation.update_config_param(param_path, new_value)


@helper_routes.route("/helper/replaceConfiguration", methods=["PUT"])
def replaceConfiguration():
    """Replaces the entire configuration with a new one"""
    new_config = request.json
    if not new_config:
        return jsonify(message="Missing new configuration in request body"), 400

    return helper_operation.replace_configuration(new_config)


@helper_routes.route("/helper/addNewConfiguration", methods=["POST"])
def add_new_configuration():
    """Adds a new category inside 'settings'."""
    data = request.json
    category_name = data.get("category_name")
    category_values = data.get("category_values")

    if not category_name or not category_values:
        return jsonify(message="Missing 'category_name' or 'category_values' in request body"), 400

    return helper_operation.add_new_configuration(category_name, category_values)

@helper_routes.route("/helper/addNewConfigSetting", methods=["PATCH"])
def add_new_config_setting():
    """Adds a new configuration inside 'settings'."""
    data = request.json
    param_path = data.get("param_path")
    new_value = data.get("new_value")
    
    if not param_path or new_value is None:
        return jsonify(message="Missing 'param_path' or 'new_value' in request body"), 400
    
    return helper_operation.add_new_config_setting(param_path, new_value)


@helper_routes.route("/helper/removeConfigParam", methods=["DELETE"])
def remove_config_param():
    """Deletes a specific parameter inside 'settings'."""
    data = request.json
    param_path = data.get("param_path")

    if not param_path:
        return jsonify(message="Missing 'param_path' in request body"), 400

    return helper_operation.remove_config_param(param_path)


@helper_routes.route("/helper/removeConfigCategory", methods=["DELETE"])
def remove_config_category():
    """Deletes an entire category inside 'settings'."""
    data = request.json
    category_name = data.get("category_name")

    if not category_name:
        return jsonify(message="Missing 'category_name' in request body"), 400

    return helper_operation.remove_config_category(category_name)
