import re  # noqa: E501
from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from capif_security import util
from capif_security.models.base_model import Model


class PlmnIdNid(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, mcc=None, mnc=None, nid=None):  # noqa: E501
        """PlmnIdNid - a model defined in OpenAPI

        :param mcc: The mcc of this PlmnIdNid.  # noqa: E501
        :type mcc: str
        :param mnc: The mnc of this PlmnIdNid.  # noqa: E501
        :type mnc: str
        :param nid: The nid of this PlmnIdNid.  # noqa: E501
        :type nid: str
        """
        self.openapi_types = {
            'mcc': str,
            'mnc': str,
            'nid': str
        }

        self.attribute_map = {
            'mcc': 'mcc',
            'mnc': 'mnc',
            'nid': 'nid'
        }

        self._mcc = mcc
        self._mnc = mnc
        self._nid = nid

    @classmethod
    def from_dict(cls, dikt) -> 'PlmnIdNid':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The PlmnIdNid of this PlmnIdNid.  # noqa: E501
        :rtype: PlmnIdNid
        """
        return util.deserialize_model(dikt, cls)

    @property
    def mcc(self) -> str:
        """Gets the mcc of this PlmnIdNid.

        Mobile Country Code part of the PLMN, comprising 3 digits, as defined in clause 9.3.3.5 of 3GPP TS 38.413.    # noqa: E501

        :return: The mcc of this PlmnIdNid.
        :rtype: str
        """
        return self._mcc

    @mcc.setter
    def mcc(self, mcc: str):
        """Sets the mcc of this PlmnIdNid.

        Mobile Country Code part of the PLMN, comprising 3 digits, as defined in clause 9.3.3.5 of 3GPP TS 38.413.    # noqa: E501

        :param mcc: The mcc of this PlmnIdNid.
        :type mcc: str
        """
        if mcc is None:
            raise ValueError("Invalid value for `mcc`, must not be `None`")  # noqa: E501
        if mcc is not None and not re.search(r'^\d{3}$', mcc):  # noqa: E501
            raise ValueError("Invalid value for `mcc`, must be a follow pattern or equal to `/^\d{3}$/`")  # noqa: E501

        self._mcc = mcc

    @property
    def mnc(self) -> str:
        """Gets the mnc of this PlmnIdNid.

        Mobile Network Code part of the PLMN, comprising 2 or 3 digits, as defined in  clause 9.3.3.5 of 3GPP TS 38.413.    # noqa: E501

        :return: The mnc of this PlmnIdNid.
        :rtype: str
        """
        return self._mnc

    @mnc.setter
    def mnc(self, mnc: str):
        """Sets the mnc of this PlmnIdNid.

        Mobile Network Code part of the PLMN, comprising 2 or 3 digits, as defined in  clause 9.3.3.5 of 3GPP TS 38.413.    # noqa: E501

        :param mnc: The mnc of this PlmnIdNid.
        :type mnc: str
        """
        if mnc is None:
            raise ValueError("Invalid value for `mnc`, must not be `None`")  # noqa: E501
        if mnc is not None and not re.search(r'^\d{2,3}$', mnc):  # noqa: E501
            raise ValueError("Invalid value for `mnc`, must be a follow pattern or equal to `/^\d{2,3}$/`")  # noqa: E501

        self._mnc = mnc

    @property
    def nid(self) -> str:
        """Gets the nid of this PlmnIdNid.

        This represents the Network Identifier, which together with a PLMN ID is used to identify an SNPN (see 3GPP TS 23.003 and 3GPP TS 23.501 clause 5.30.2.1).    # noqa: E501

        :return: The nid of this PlmnIdNid.
        :rtype: str
        """
        return self._nid

    @nid.setter
    def nid(self, nid: str):
        """Sets the nid of this PlmnIdNid.

        This represents the Network Identifier, which together with a PLMN ID is used to identify an SNPN (see 3GPP TS 23.003 and 3GPP TS 23.501 clause 5.30.2.1).    # noqa: E501

        :param nid: The nid of this PlmnIdNid.
        :type nid: str
        """
        if nid is not None and not re.search(r'^[A-Fa-f0-9]{11}$', nid):  # noqa: E501
            raise ValueError("Invalid value for `nid`, must be a follow pattern or equal to `/^[A-Fa-f0-9]{11}$/`")  # noqa: E501

        self._nid = nid
