from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from capif_security import util
from capif_security.models.base_model import Model
from capif_security.models.res_owner_id import ResOwnerId  # noqa: E501


class AccessTokenClaims(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, iss=None, scope=None, exp=None, res_owner_id=None):  # noqa: E501
        """AccessTokenClaims - a model defined in OpenAPI

        :param iss: The iss of this AccessTokenClaims.  # noqa: E501
        :type iss: str
        :param scope: The scope of this AccessTokenClaims.  # noqa: E501
        :type scope: str
        :param exp: The exp of this AccessTokenClaims.  # noqa: E501
        :type exp: int
        :param res_owner_id: The res_owner_id of this AccessTokenClaims.  # noqa: E501
        :type res_owner_id: ResOwnerId
        """
        self.openapi_types = {
            'iss': str,
            'scope': str,
            'exp': int,
            'res_owner_id': ResOwnerId
        }

        self.attribute_map = {
            'iss': 'iss',
            'scope': 'scope',
            'exp': 'exp',
            'res_owner_id': 'resOwnerId'
        }

        self._iss = iss
        self._scope = scope
        self._exp = exp
        self._res_owner_id = res_owner_id

    @classmethod
    def from_dict(cls, dikt) -> 'AccessTokenClaims':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The AccessTokenClaims of this AccessTokenClaims.  # noqa: E501
        :rtype: AccessTokenClaims
        """
        return util.deserialize_model(dikt, cls)

    @property
    def iss(self) -> str:
        """Gets the iss of this AccessTokenClaims.


        :return: The iss of this AccessTokenClaims.
        :rtype: str
        """
        return self._iss

    @iss.setter
    def iss(self, iss: str):
        """Sets the iss of this AccessTokenClaims.


        :param iss: The iss of this AccessTokenClaims.
        :type iss: str
        """
        if iss is None:
            raise ValueError("Invalid value for `iss`, must not be `None`")  # noqa: E501

        self._iss = iss

    @property
    def scope(self) -> str:
        """Gets the scope of this AccessTokenClaims.


        :return: The scope of this AccessTokenClaims.
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope: str):
        """Sets the scope of this AccessTokenClaims.


        :param scope: The scope of this AccessTokenClaims.
        :type scope: str
        """
        if scope is None:
            raise ValueError("Invalid value for `scope`, must not be `None`")  # noqa: E501

        self._scope = scope

    @property
    def exp(self) -> int:
        """Gets the exp of this AccessTokenClaims.

        Unsigned integer identifying a period of time in units of seconds.  # noqa: E501

        :return: The exp of this AccessTokenClaims.
        :rtype: int
        """
        return self._exp

    @exp.setter
    def exp(self, exp: int):
        """Sets the exp of this AccessTokenClaims.

        Unsigned integer identifying a period of time in units of seconds.  # noqa: E501

        :param exp: The exp of this AccessTokenClaims.
        :type exp: int
        """
        if exp is None:
            raise ValueError("Invalid value for `exp`, must not be `None`")  # noqa: E501
        if exp is not None and exp < 0:  # noqa: E501
            raise ValueError("Invalid value for `exp`, must be a value greater than or equal to `0`")  # noqa: E501

        self._exp = exp

    @property
    def res_owner_id(self) -> ResOwnerId:
        """Gets the res_owner_id of this AccessTokenClaims.


        :return: The res_owner_id of this AccessTokenClaims.
        :rtype: ResOwnerId
        """
        return self._res_owner_id

    @res_owner_id.setter
    def res_owner_id(self, res_owner_id: ResOwnerId):
        """Sets the res_owner_id of this AccessTokenClaims.


        :param res_owner_id: The res_owner_id of this AccessTokenClaims.
        :type res_owner_id: ResOwnerId
        """

        self._res_owner_id = res_owner_id
