from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from capif_routing_info import util
from capif_routing_info.models.base_model import Model
from capif_routing_info.models.communication_type import CommunicationType  # noqa: E501
from capif_routing_info.models.custom_operation import CustomOperation  # noqa: E501
from capif_routing_info.models.operation import Operation  # noqa: E501


class Resource(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, resource_name=None, comm_type=None, uri=None, cust_op_name=None, cust_operations=None, operations=None, description=None):  # noqa: E501
        """Resource - a model defined in OpenAPI

        :param resource_name: The resource_name of this Resource.  # noqa: E501
        :type resource_name: str
        :param comm_type: The comm_type of this Resource.  # noqa: E501
        :type comm_type: CommunicationType
        :param uri: The uri of this Resource.  # noqa: E501
        :type uri: str
        :param cust_op_name: The cust_op_name of this Resource.  # noqa: E501
        :type cust_op_name: str
        :param cust_operations: The cust_operations of this Resource.  # noqa: E501
        :type cust_operations: List[CustomOperation]
        :param operations: The operations of this Resource.  # noqa: E501
        :type operations: List[Operation]
        :param description: The description of this Resource.  # noqa: E501
        :type description: str
        """
        self.openapi_types = {
            'resource_name': str,
            'comm_type': CommunicationType,
            'uri': str,
            'cust_op_name': str,
            'cust_operations': List[CustomOperation],
            'operations': List[Operation],
            'description': str
        }

        self.attribute_map = {
            'resource_name': 'resourceName',
            'comm_type': 'commType',
            'uri': 'uri',
            'cust_op_name': 'custOpName',
            'cust_operations': 'custOperations',
            'operations': 'operations',
            'description': 'description'
        }

        self._resource_name = resource_name
        self._comm_type = comm_type
        self._uri = uri
        self._cust_op_name = cust_op_name
        self._cust_operations = cust_operations
        self._operations = operations
        self._description = description

    @classmethod
    def from_dict(cls, dikt) -> 'Resource':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Resource of this Resource.  # noqa: E501
        :rtype: Resource
        """
        return util.deserialize_model(dikt, cls)

    @property
    def resource_name(self) -> str:
        """Gets the resource_name of this Resource.

        Resource name  # noqa: E501

        :return: The resource_name of this Resource.
        :rtype: str
        """
        return self._resource_name

    @resource_name.setter
    def resource_name(self, resource_name: str):
        """Sets the resource_name of this Resource.

        Resource name  # noqa: E501

        :param resource_name: The resource_name of this Resource.
        :type resource_name: str
        """
        if resource_name is None:
            raise ValueError("Invalid value for `resource_name`, must not be `None`")  # noqa: E501

        self._resource_name = resource_name

    @property
    def comm_type(self) -> CommunicationType:
        """Gets the comm_type of this Resource.


        :return: The comm_type of this Resource.
        :rtype: CommunicationType
        """
        return self._comm_type

    @comm_type.setter
    def comm_type(self, comm_type: CommunicationType):
        """Sets the comm_type of this Resource.


        :param comm_type: The comm_type of this Resource.
        :type comm_type: CommunicationType
        """
        if comm_type is None:
            raise ValueError("Invalid value for `comm_type`, must not be `None`")  # noqa: E501

        self._comm_type = comm_type

    @property
    def uri(self) -> str:
        """Gets the uri of this Resource.

        Relative URI of the API resource, it is set as {apiSpecificSuffixes} part of the URI structure as defined in clause 5.2.4 of 3GPP TS 29.122.   # noqa: E501

        :return: The uri of this Resource.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri: str):
        """Sets the uri of this Resource.

        Relative URI of the API resource, it is set as {apiSpecificSuffixes} part of the URI structure as defined in clause 5.2.4 of 3GPP TS 29.122.   # noqa: E501

        :param uri: The uri of this Resource.
        :type uri: str
        """
        if uri is None:
            raise ValueError("Invalid value for `uri`, must not be `None`")  # noqa: E501

        self._uri = uri

    @property
    def cust_op_name(self) -> str:
        """Gets the cust_op_name of this Resource.

        it is set as {custOpName} part of the URI structure for a custom operation associated with a resource as defined in clause 5.2.4 of 3GPP TS 29.122.   # noqa: E501

        :return: The cust_op_name of this Resource.
        :rtype: str
        """
        return self._cust_op_name

    @cust_op_name.setter
    def cust_op_name(self, cust_op_name: str):
        """Sets the cust_op_name of this Resource.

        it is set as {custOpName} part of the URI structure for a custom operation associated with a resource as defined in clause 5.2.4 of 3GPP TS 29.122.   # noqa: E501

        :param cust_op_name: The cust_op_name of this Resource.
        :type cust_op_name: str
        """

        self._cust_op_name = cust_op_name

    @property
    def cust_operations(self) -> List[CustomOperation]:
        """Gets the cust_operations of this Resource.

        Custom operations associated with this resource.   # noqa: E501

        :return: The cust_operations of this Resource.
        :rtype: List[CustomOperation]
        """
        return self._cust_operations

    @cust_operations.setter
    def cust_operations(self, cust_operations: List[CustomOperation]):
        """Sets the cust_operations of this Resource.

        Custom operations associated with this resource.   # noqa: E501

        :param cust_operations: The cust_operations of this Resource.
        :type cust_operations: List[CustomOperation]
        """
        if cust_operations is not None and len(cust_operations) < 1:
            raise ValueError("Invalid value for `cust_operations`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._cust_operations = cust_operations

    @property
    def operations(self) -> List[Operation]:
        """Gets the operations of this Resource.

        Supported HTTP methods for the API resource. Only applicable when the protocol in AefProfile indicates HTTP.   # noqa: E501

        :return: The operations of this Resource.
        :rtype: List[Operation]
        """
        return self._operations

    @operations.setter
    def operations(self, operations: List[Operation]):
        """Sets the operations of this Resource.

        Supported HTTP methods for the API resource. Only applicable when the protocol in AefProfile indicates HTTP.   # noqa: E501

        :param operations: The operations of this Resource.
        :type operations: List[Operation]
        """
        if operations is not None and len(operations) < 1:
            raise ValueError("Invalid value for `operations`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._operations = operations

    @property
    def description(self) -> str:
        """Gets the description of this Resource.

        Text description of the API resource  # noqa: E501

        :return: The description of this Resource.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str):
        """Sets the description of this Resource.

        Text description of the API resource  # noqa: E501

        :param description: The description of this Resource.
        :type description: str
        """

        self._description = description
