from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from service_apis import util
from service_apis.models.base_model import Model
from service_apis.models.local_origin import LocalOrigin  # noqa: E501
from service_apis.models.relative_cartesian_location import RelativeCartesianLocation  # noqa: E501
from service_apis.models.supported_gad_shapes import SupportedGADShapes  # noqa: E501
from service_apis.models.uncertainty_ellipsoid import UncertaintyEllipsoid  # noqa: E501


class Local3dPointUncertaintyEllipsoid(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, shape=None, local_origin=None, point=None, uncertainty_ellipsoid=None, confidence=None):  # noqa: E501
        """Local3dPointUncertaintyEllipsoid - a model defined in OpenAPI

        :param shape: The shape of this Local3dPointUncertaintyEllipsoid.  # noqa: E501
        :type shape: SupportedGADShapes
        :param local_origin: The local_origin of this Local3dPointUncertaintyEllipsoid.  # noqa: E501
        :type local_origin: LocalOrigin
        :param point: The point of this Local3dPointUncertaintyEllipsoid.  # noqa: E501
        :type point: RelativeCartesianLocation
        :param uncertainty_ellipsoid: The uncertainty_ellipsoid of this Local3dPointUncertaintyEllipsoid.  # noqa: E501
        :type uncertainty_ellipsoid: UncertaintyEllipsoid
        :param confidence: The confidence of this Local3dPointUncertaintyEllipsoid.  # noqa: E501
        :type confidence: int
        """
        self.openapi_types = {
            'shape': SupportedGADShapes,
            'local_origin': LocalOrigin,
            'point': RelativeCartesianLocation,
            'uncertainty_ellipsoid': UncertaintyEllipsoid,
            'confidence': int
        }

        self.attribute_map = {
            'shape': 'shape',
            'local_origin': 'localOrigin',
            'point': 'point',
            'uncertainty_ellipsoid': 'uncertaintyEllipsoid',
            'confidence': 'confidence'
        }

        self._shape = shape
        self._local_origin = local_origin
        self._point = point
        self._uncertainty_ellipsoid = uncertainty_ellipsoid
        self._confidence = confidence

    @classmethod
    def from_dict(cls, dikt) -> 'Local3dPointUncertaintyEllipsoid':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Local3dPointUncertaintyEllipsoid of this Local3dPointUncertaintyEllipsoid.  # noqa: E501
        :rtype: Local3dPointUncertaintyEllipsoid
        """
        return util.deserialize_model(dikt, cls)

    @property
    def shape(self) -> SupportedGADShapes:
        """Gets the shape of this Local3dPointUncertaintyEllipsoid.


        :return: The shape of this Local3dPointUncertaintyEllipsoid.
        :rtype: SupportedGADShapes
        """
        return self._shape

    @shape.setter
    def shape(self, shape: SupportedGADShapes):
        """Sets the shape of this Local3dPointUncertaintyEllipsoid.


        :param shape: The shape of this Local3dPointUncertaintyEllipsoid.
        :type shape: SupportedGADShapes
        """
        if shape is None:
            raise ValueError("Invalid value for `shape`, must not be `None`")  # noqa: E501

        self._shape = shape

    @property
    def local_origin(self) -> LocalOrigin:
        """Gets the local_origin of this Local3dPointUncertaintyEllipsoid.


        :return: The local_origin of this Local3dPointUncertaintyEllipsoid.
        :rtype: LocalOrigin
        """
        return self._local_origin

    @local_origin.setter
    def local_origin(self, local_origin: LocalOrigin):
        """Sets the local_origin of this Local3dPointUncertaintyEllipsoid.


        :param local_origin: The local_origin of this Local3dPointUncertaintyEllipsoid.
        :type local_origin: LocalOrigin
        """
        if local_origin is None:
            raise ValueError("Invalid value for `local_origin`, must not be `None`")  # noqa: E501

        self._local_origin = local_origin

    @property
    def point(self) -> RelativeCartesianLocation:
        """Gets the point of this Local3dPointUncertaintyEllipsoid.


        :return: The point of this Local3dPointUncertaintyEllipsoid.
        :rtype: RelativeCartesianLocation
        """
        return self._point

    @point.setter
    def point(self, point: RelativeCartesianLocation):
        """Sets the point of this Local3dPointUncertaintyEllipsoid.


        :param point: The point of this Local3dPointUncertaintyEllipsoid.
        :type point: RelativeCartesianLocation
        """
        if point is None:
            raise ValueError("Invalid value for `point`, must not be `None`")  # noqa: E501

        self._point = point

    @property
    def uncertainty_ellipsoid(self) -> UncertaintyEllipsoid:
        """Gets the uncertainty_ellipsoid of this Local3dPointUncertaintyEllipsoid.


        :return: The uncertainty_ellipsoid of this Local3dPointUncertaintyEllipsoid.
        :rtype: UncertaintyEllipsoid
        """
        return self._uncertainty_ellipsoid

    @uncertainty_ellipsoid.setter
    def uncertainty_ellipsoid(self, uncertainty_ellipsoid: UncertaintyEllipsoid):
        """Sets the uncertainty_ellipsoid of this Local3dPointUncertaintyEllipsoid.


        :param uncertainty_ellipsoid: The uncertainty_ellipsoid of this Local3dPointUncertaintyEllipsoid.
        :type uncertainty_ellipsoid: UncertaintyEllipsoid
        """
        if uncertainty_ellipsoid is None:
            raise ValueError("Invalid value for `uncertainty_ellipsoid`, must not be `None`")  # noqa: E501

        self._uncertainty_ellipsoid = uncertainty_ellipsoid

    @property
    def confidence(self) -> int:
        """Gets the confidence of this Local3dPointUncertaintyEllipsoid.

        Indicates value of confidence.  # noqa: E501

        :return: The confidence of this Local3dPointUncertaintyEllipsoid.
        :rtype: int
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence: int):
        """Sets the confidence of this Local3dPointUncertaintyEllipsoid.

        Indicates value of confidence.  # noqa: E501

        :param confidence: The confidence of this Local3dPointUncertaintyEllipsoid.
        :type confidence: int
        """
        if confidence is None:
            raise ValueError("Invalid value for `confidence`, must not be `None`")  # noqa: E501
        if confidence is not None and confidence > 100:  # noqa: E501
            raise ValueError("Invalid value for `confidence`, must be a value less than or equal to `100`")  # noqa: E501
        if confidence is not None and confidence < 0:  # noqa: E501
            raise ValueError("Invalid value for `confidence`, must be a value greater than or equal to `0`")  # noqa: E501

        self._confidence = confidence
