import re  # noqa: E501
from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from logs import util
from logs.models.base_model import Model
from logs.models.invocation_log import InvocationLog  # noqa: E501
from logs.models.log import Log  # noqa: E501


class InvocationLogsRetrieveRes(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, aef_id=None, api_invoker_id=None, logs=None, supported_features=None, multiple_invocation_logs=None):  # noqa: E501
        """InvocationLogsRetrieveRes - a model defined in OpenAPI

        :param aef_id: The aef_id of this InvocationLogsRetrieveRes.  # noqa: E501
        :type aef_id: str
        :param api_invoker_id: The api_invoker_id of this InvocationLogsRetrieveRes.  # noqa: E501
        :type api_invoker_id: str
        :param logs: The logs of this InvocationLogsRetrieveRes.  # noqa: E501
        :type logs: List[Log]
        :param supported_features: The supported_features of this InvocationLogsRetrieveRes.  # noqa: E501
        :type supported_features: str
        :param multiple_invocation_logs: The multiple_invocation_logs of this InvocationLogsRetrieveRes.  # noqa: E501
        :type multiple_invocation_logs: List[InvocationLog]
        """
        self.openapi_types = {
            'aef_id': str,
            'api_invoker_id': str,
            'logs': List[Log],
            'supported_features': str,
            'multiple_invocation_logs': List[InvocationLog]
        }

        self.attribute_map = {
            'aef_id': 'aefId',
            'api_invoker_id': 'apiInvokerId',
            'logs': 'logs',
            'supported_features': 'supportedFeatures',
            'multiple_invocation_logs': 'multipleInvocationLogs'
        }

        self._aef_id = aef_id
        self._api_invoker_id = api_invoker_id
        self._logs = logs
        self._supported_features = supported_features
        self._multiple_invocation_logs = multiple_invocation_logs

    @classmethod
    def from_dict(cls, dikt) -> 'InvocationLogsRetrieveRes':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The InvocationLogsRetrieveRes of this InvocationLogsRetrieveRes.  # noqa: E501
        :rtype: InvocationLogsRetrieveRes
        """
        return util.deserialize_model(dikt, cls)

    @property
    def aef_id(self) -> str:
        """Gets the aef_id of this InvocationLogsRetrieveRes.

        Identity information of the API exposing function requesting logging of service API invocations   # noqa: E501

        :return: The aef_id of this InvocationLogsRetrieveRes.
        :rtype: str
        """
        return self._aef_id

    @aef_id.setter
    def aef_id(self, aef_id: str):
        """Sets the aef_id of this InvocationLogsRetrieveRes.

        Identity information of the API exposing function requesting logging of service API invocations   # noqa: E501

        :param aef_id: The aef_id of this InvocationLogsRetrieveRes.
        :type aef_id: str
        """
        if aef_id is None:
            raise ValueError("Invalid value for `aef_id`, must not be `None`")  # noqa: E501

        self._aef_id = aef_id

    @property
    def api_invoker_id(self) -> str:
        """Gets the api_invoker_id of this InvocationLogsRetrieveRes.

        Identity of the API invoker which invoked the service API  # noqa: E501

        :return: The api_invoker_id of this InvocationLogsRetrieveRes.
        :rtype: str
        """
        return self._api_invoker_id

    @api_invoker_id.setter
    def api_invoker_id(self, api_invoker_id: str):
        """Sets the api_invoker_id of this InvocationLogsRetrieveRes.

        Identity of the API invoker which invoked the service API  # noqa: E501

        :param api_invoker_id: The api_invoker_id of this InvocationLogsRetrieveRes.
        :type api_invoker_id: str
        """
        if api_invoker_id is None:
            raise ValueError("Invalid value for `api_invoker_id`, must not be `None`")  # noqa: E501

        self._api_invoker_id = api_invoker_id

    @property
    def logs(self) -> List[Log]:
        """Gets the logs of this InvocationLogsRetrieveRes.

        Service API invocation log  # noqa: E501

        :return: The logs of this InvocationLogsRetrieveRes.
        :rtype: List[Log]
        """
        return self._logs

    @logs.setter
    def logs(self, logs: List[Log]):
        """Sets the logs of this InvocationLogsRetrieveRes.

        Service API invocation log  # noqa: E501

        :param logs: The logs of this InvocationLogsRetrieveRes.
        :type logs: List[Log]
        """
        if logs is None:
            raise ValueError("Invalid value for `logs`, must not be `None`")  # noqa: E501
        if logs is not None and len(logs) < 1:
            raise ValueError("Invalid value for `logs`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._logs = logs

    @property
    def supported_features(self) -> str:
        """Gets the supported_features of this InvocationLogsRetrieveRes.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :return: The supported_features of this InvocationLogsRetrieveRes.
        :rtype: str
        """
        return self._supported_features

    @supported_features.setter
    def supported_features(self, supported_features: str):
        """Sets the supported_features of this InvocationLogsRetrieveRes.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :param supported_features: The supported_features of this InvocationLogsRetrieveRes.
        :type supported_features: str
        """
        if supported_features is not None and not re.search(r'^[A-Fa-f0-9]*$', supported_features):  # noqa: E501
            raise ValueError("Invalid value for `supported_features`, must be a follow pattern or equal to `/^[A-Fa-f0-9]*$/`")  # noqa: E501

        self._supported_features = supported_features

    @property
    def multiple_invocation_logs(self) -> List[InvocationLog]:
        """Gets the multiple_invocation_logs of this InvocationLogsRetrieveRes.


        :return: The multiple_invocation_logs of this InvocationLogsRetrieveRes.
        :rtype: List[InvocationLog]
        """
        return self._multiple_invocation_logs

    @multiple_invocation_logs.setter
    def multiple_invocation_logs(self, multiple_invocation_logs: List[InvocationLog]):
        """Sets the multiple_invocation_logs of this InvocationLogsRetrieveRes.


        :param multiple_invocation_logs: The multiple_invocation_logs of this InvocationLogsRetrieveRes.
        :type multiple_invocation_logs: List[InvocationLog]
        """
        if multiple_invocation_logs is None:
            raise ValueError("Invalid value for `multiple_invocation_logs`, must not be `None`")  # noqa: E501
        if multiple_invocation_logs is not None and len(multiple_invocation_logs) < 1:
            raise ValueError("Invalid value for `multiple_invocation_logs`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._multiple_invocation_logs = multiple_invocation_logs
