from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from api_invoker_management import util
from api_invoker_management.models.base_model import Model


class PublishedApiPath(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, ccf_ids=None):  # noqa: E501
        """PublishedApiPath - a model defined in OpenAPI

        :param ccf_ids: The ccf_ids of this PublishedApiPath.  # noqa: E501
        :type ccf_ids: List[str]
        """
        self.openapi_types = {
            'ccf_ids': List[str]
        }

        self.attribute_map = {
            'ccf_ids': 'ccfIds'
        }

        self._ccf_ids = ccf_ids

    @classmethod
    def from_dict(cls, dikt) -> 'PublishedApiPath':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The PublishedApiPath of this PublishedApiPath.  # noqa: E501
        :rtype: PublishedApiPath
        """
        return util.deserialize_model(dikt, cls)

    @property
    def ccf_ids(self) -> List[str]:
        """Gets the ccf_ids of this PublishedApiPath.

        A list of CCF identifiers where the service API is already published.  # noqa: E501

        :return: The ccf_ids of this PublishedApiPath.
        :rtype: List[str]
        """
        return self._ccf_ids

    @ccf_ids.setter
    def ccf_ids(self, ccf_ids: List[str]):
        """Sets the ccf_ids of this PublishedApiPath.

        A list of CCF identifiers where the service API is already published.  # noqa: E501

        :param ccf_ids: The ccf_ids of this PublishedApiPath.
        :type ccf_ids: List[str]
        """
        if ccf_ids is not None and len(ccf_ids) < 1:
            raise ValueError("Invalid value for `ccf_ids`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._ccf_ids = ccf_ids
