from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from api_invoker_management import util
from api_invoker_management.models.base_model import Model


class OnboardingInformation(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, api_invoker_public_key=None, api_invoker_certificate=None, onboarding_secret=None):  # noqa: E501
        """OnboardingInformation - a model defined in OpenAPI

        :param api_invoker_public_key: The api_invoker_public_key of this OnboardingInformation.  # noqa: E501
        :type api_invoker_public_key: str
        :param api_invoker_certificate: The api_invoker_certificate of this OnboardingInformation.  # noqa: E501
        :type api_invoker_certificate: str
        :param onboarding_secret: The onboarding_secret of this OnboardingInformation.  # noqa: E501
        :type onboarding_secret: str
        """
        self.openapi_types = {
            'api_invoker_public_key': str,
            'api_invoker_certificate': str,
            'onboarding_secret': str
        }

        self.attribute_map = {
            'api_invoker_public_key': 'apiInvokerPublicKey',
            'api_invoker_certificate': 'apiInvokerCertificate',
            'onboarding_secret': 'onboardingSecret'
        }

        self._api_invoker_public_key = api_invoker_public_key
        self._api_invoker_certificate = api_invoker_certificate
        self._onboarding_secret = onboarding_secret

    @classmethod
    def from_dict(cls, dikt) -> 'OnboardingInformation':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The OnboardingInformation of this OnboardingInformation.  # noqa: E501
        :rtype: OnboardingInformation
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api_invoker_public_key(self) -> str:
        """Gets the api_invoker_public_key of this OnboardingInformation.

        The API Invoker's public key  # noqa: E501

        :return: The api_invoker_public_key of this OnboardingInformation.
        :rtype: str
        """
        return self._api_invoker_public_key

    @api_invoker_public_key.setter
    def api_invoker_public_key(self, api_invoker_public_key: str):
        """Sets the api_invoker_public_key of this OnboardingInformation.

        The API Invoker's public key  # noqa: E501

        :param api_invoker_public_key: The api_invoker_public_key of this OnboardingInformation.
        :type api_invoker_public_key: str
        """
        if api_invoker_public_key is None:
            raise ValueError("Invalid value for `api_invoker_public_key`, must not be `None`")  # noqa: E501

        self._api_invoker_public_key = api_invoker_public_key

    @property
    def api_invoker_certificate(self) -> str:
        """Gets the api_invoker_certificate of this OnboardingInformation.

        The API Invoker's generic client certificate, provided by the CAPIF core function.   # noqa: E501

        :return: The api_invoker_certificate of this OnboardingInformation.
        :rtype: str
        """
        return self._api_invoker_certificate

    @api_invoker_certificate.setter
    def api_invoker_certificate(self, api_invoker_certificate: str):
        """Sets the api_invoker_certificate of this OnboardingInformation.

        The API Invoker's generic client certificate, provided by the CAPIF core function.   # noqa: E501

        :param api_invoker_certificate: The api_invoker_certificate of this OnboardingInformation.
        :type api_invoker_certificate: str
        """

        self._api_invoker_certificate = api_invoker_certificate

    @property
    def onboarding_secret(self) -> str:
        """Gets the onboarding_secret of this OnboardingInformation.

        The API Invoker's onboarding secret, provided by the CAPIF core function.   # noqa: E501

        :return: The onboarding_secret of this OnboardingInformation.
        :rtype: str
        """
        return self._onboarding_secret

    @onboarding_secret.setter
    def onboarding_secret(self, onboarding_secret: str):
        """Sets the onboarding_secret of this OnboardingInformation.

        The API Invoker's onboarding secret, provided by the CAPIF core function.   # noqa: E501

        :param onboarding_secret: The onboarding_secret of this OnboardingInformation.
        :type onboarding_secret: str
        """

        self._onboarding_secret = onboarding_secret
