from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from api_invoker_management import util
from api_invoker_management.models.base_model import Model
from api_invoker_management.models.civic_address import CivicAddress  # noqa: E501
from api_invoker_management.models.geographic_area import GeographicArea  # noqa: E501


class AefLocation(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, civic_addr=None, geo_area=None, dc_id=None):  # noqa: E501
        """AefLocation - a model defined in OpenAPI

        :param civic_addr: The civic_addr of this AefLocation.  # noqa: E501
        :type civic_addr: CivicAddress
        :param geo_area: The geo_area of this AefLocation.  # noqa: E501
        :type geo_area: GeographicArea
        :param dc_id: The dc_id of this AefLocation.  # noqa: E501
        :type dc_id: str
        """
        self.openapi_types = {
            'civic_addr': CivicAddress,
            'geo_area': GeographicArea,
            'dc_id': str
        }

        self.attribute_map = {
            'civic_addr': 'civicAddr',
            'geo_area': 'geoArea',
            'dc_id': 'dcId'
        }

        self._civic_addr = civic_addr
        self._geo_area = geo_area
        self._dc_id = dc_id

    @classmethod
    def from_dict(cls, dikt) -> 'AefLocation':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The AefLocation of this AefLocation.  # noqa: E501
        :rtype: AefLocation
        """
        return util.deserialize_model(dikt, cls)

    @property
    def civic_addr(self) -> CivicAddress:
        """Gets the civic_addr of this AefLocation.


        :return: The civic_addr of this AefLocation.
        :rtype: CivicAddress
        """
        return self._civic_addr

    @civic_addr.setter
    def civic_addr(self, civic_addr: CivicAddress):
        """Sets the civic_addr of this AefLocation.


        :param civic_addr: The civic_addr of this AefLocation.
        :type civic_addr: CivicAddress
        """

        self._civic_addr = civic_addr

    @property
    def geo_area(self) -> GeographicArea:
        """Gets the geo_area of this AefLocation.


        :return: The geo_area of this AefLocation.
        :rtype: GeographicArea
        """
        return self._geo_area

    @geo_area.setter
    def geo_area(self, geo_area: GeographicArea):
        """Sets the geo_area of this AefLocation.


        :param geo_area: The geo_area of this AefLocation.
        :type geo_area: GeographicArea
        """

        self._geo_area = geo_area

    @property
    def dc_id(self) -> str:
        """Gets the dc_id of this AefLocation.

        Identifies the data center where the AEF providing the service API is located.   # noqa: E501

        :return: The dc_id of this AefLocation.
        :rtype: str
        """
        return self._dc_id

    @dc_id.setter
    def dc_id(self, dc_id: str):
        """Sets the dc_id of this AefLocation.

        Identifies the data center where the AEF providing the service API is located.   # noqa: E501

        :param dc_id: The dc_id of this AefLocation.
        :type dc_id: str
        """

        self._dc_id = dc_id
