# capif

![Version: v3.1.6](https://img.shields.io/badge/Version-v3.1.6-informational?style=flat-square) ![Type: application](https://img.shields.io/badge/Type-application-informational?style=flat-square) ![AppVersion: v3.1.6](https://img.shields.io/badge/AppVersion-v3.1.6-informational?style=flat-square)

A Helm chart to CAPIF in Kubernetes

## Requirements

| Repository | Name | Version |
|------------|------|---------|
|  | fluentbit | * |
|  | grafana | * |
|  | loki | * |
|  | mock-server | * |
|  | mongo | * |
|  | mongo-express | * |
|  | mongo-register | * |
|  | mongo-register-express | * |
|  | nginx | * |
|  | ocf-access-control-policy | * |
|  | ocf-api-invocation-logs | * |
|  | ocf-api-invoker-management | * |
|  | ocf-api-provider-management | * |
|  | ocf-auditing-api-logs | * |
|  | ocf-discover-service-api | * |
|  | ocf-events | * |
|  | ocf-helper | * |
|  | ocf-publish-service-api | * |
|  | ocf-register | * |
|  | ocf-routing-info | * |
|  | ocf-security | * |
|  | otelcollector | * |
|  | redis | * |
|  | renderer | * |
| https://grafana.github.io/helm-charts | tempo | ^1.3.1 |

## Values

| Key | Type | Default | Description |
|-----|------|---------|-------------|
| fluentbit | object | `{"enabled":false}` | With fluentbit.enabled: false. It won't be deployed |
| grafana | object | `{"enabled":false}` | With grafana.enabled: false. It won't be deployed |
| loki | object | `{"enabled":false}` | With loki.enabled: false. It won't be deployed |
| mock-server | object | `{"enabled":false}` | With mock-server.enabled: false. It won't be deployed |
| mongo-express | object | `{"enabled":false}` | With mongo-express.enabled: false. It won't be deployed |
| mongo-register-express | object | `{"enabled":false}` | With mongo-register-express.enabled: false. It won't be deployed |
| otelcollector | object | `{"enabled":false}` | With otelcollector.enabled: false. It won't be deployed |
| renderer | object | `{"enabled":false}` | With renderer.enabled: false. It won't be deployed |
| tempo | object | `{"enabled":true,"persistence":{"enabled":true,"size":"3Gi"},"tempo":{"metricsGenerator":{"enabled":true,"remoteWriteUrl":"http://prometheus.mon.svc.cluster.local:9090/api/v1/write"}}}` | With tempo.enabled: false. It won't be deployed |

----------------------------------------------
Autogenerated from chart metadata using [helm-docs v1.13.1](https://github.com/norwoodj/helm-docs/releases/v1.13.1)
