from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from capif_routing_info.models.base_model import Model
from capif_routing_info.models.gad_shape import GADShape
from capif_routing_info.models.geographical_coordinates import GeographicalCoordinates
from capif_routing_info.models.supported_gad_shapes import SupportedGADShapes
from capif_routing_info.models.uncertainty_ellipse import UncertaintyEllipse
from capif_routing_info import util

from capif_routing_info.models.gad_shape import GADShape  # noqa: E501
from capif_routing_info.models.geographical_coordinates import GeographicalCoordinates  # noqa: E501
from capif_routing_info.models.supported_gad_shapes import SupportedGADShapes  # noqa: E501
from capif_routing_info.models.uncertainty_ellipse import UncertaintyEllipse  # noqa: E501

class PointAltitudeUncertainty(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, shape=None, point=None, altitude=None, uncertainty_ellipse=None, uncertainty_altitude=None, confidence=None, v_confidence=None):  # noqa: E501
        """PointAltitudeUncertainty - a model defined in OpenAPI

        :param shape: The shape of this PointAltitudeUncertainty.  # noqa: E501
        :type shape: SupportedGADShapes
        :param point: The point of this PointAltitudeUncertainty.  # noqa: E501
        :type point: GeographicalCoordinates
        :param altitude: The altitude of this PointAltitudeUncertainty.  # noqa: E501
        :type altitude: float
        :param uncertainty_ellipse: The uncertainty_ellipse of this PointAltitudeUncertainty.  # noqa: E501
        :type uncertainty_ellipse: UncertaintyEllipse
        :param uncertainty_altitude: The uncertainty_altitude of this PointAltitudeUncertainty.  # noqa: E501
        :type uncertainty_altitude: float
        :param confidence: The confidence of this PointAltitudeUncertainty.  # noqa: E501
        :type confidence: int
        :param v_confidence: The v_confidence of this PointAltitudeUncertainty.  # noqa: E501
        :type v_confidence: int
        """
        self.openapi_types = {
            'shape': SupportedGADShapes,
            'point': GeographicalCoordinates,
            'altitude': float,
            'uncertainty_ellipse': UncertaintyEllipse,
            'uncertainty_altitude': float,
            'confidence': int,
            'v_confidence': int
        }

        self.attribute_map = {
            'shape': 'shape',
            'point': 'point',
            'altitude': 'altitude',
            'uncertainty_ellipse': 'uncertaintyEllipse',
            'uncertainty_altitude': 'uncertaintyAltitude',
            'confidence': 'confidence',
            'v_confidence': 'vConfidence'
        }

        self._shape = shape
        self._point = point
        self._altitude = altitude
        self._uncertainty_ellipse = uncertainty_ellipse
        self._uncertainty_altitude = uncertainty_altitude
        self._confidence = confidence
        self._v_confidence = v_confidence

    @classmethod
    def from_dict(cls, dikt) -> 'PointAltitudeUncertainty':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The PointAltitudeUncertainty of this PointAltitudeUncertainty.  # noqa: E501
        :rtype: PointAltitudeUncertainty
        """
        return util.deserialize_model(dikt, cls)

    @property
    def shape(self) -> SupportedGADShapes:
        """Gets the shape of this PointAltitudeUncertainty.


        :return: The shape of this PointAltitudeUncertainty.
        :rtype: SupportedGADShapes
        """
        return self._shape

    @shape.setter
    def shape(self, shape: SupportedGADShapes):
        """Sets the shape of this PointAltitudeUncertainty.


        :param shape: The shape of this PointAltitudeUncertainty.
        :type shape: SupportedGADShapes
        """
        if shape is None:
            raise ValueError("Invalid value for `shape`, must not be `None`")  # noqa: E501

        self._shape = shape

    @property
    def point(self) -> GeographicalCoordinates:
        """Gets the point of this PointAltitudeUncertainty.


        :return: The point of this PointAltitudeUncertainty.
        :rtype: GeographicalCoordinates
        """
        return self._point

    @point.setter
    def point(self, point: GeographicalCoordinates):
        """Sets the point of this PointAltitudeUncertainty.


        :param point: The point of this PointAltitudeUncertainty.
        :type point: GeographicalCoordinates
        """
        if point is None:
            raise ValueError("Invalid value for `point`, must not be `None`")  # noqa: E501

        self._point = point

    @property
    def altitude(self) -> float:
        """Gets the altitude of this PointAltitudeUncertainty.

        Indicates value of altitude.  # noqa: E501

        :return: The altitude of this PointAltitudeUncertainty.
        :rtype: float
        """
        return self._altitude

    @altitude.setter
    def altitude(self, altitude: float):
        """Sets the altitude of this PointAltitudeUncertainty.

        Indicates value of altitude.  # noqa: E501

        :param altitude: The altitude of this PointAltitudeUncertainty.
        :type altitude: float
        """
        if altitude is None:
            raise ValueError("Invalid value for `altitude`, must not be `None`")  # noqa: E501
        if altitude is not None and altitude > 32767:  # noqa: E501
            raise ValueError("Invalid value for `altitude`, must be a value less than or equal to `32767`")  # noqa: E501
        if altitude is not None and altitude < -32767:  # noqa: E501
            raise ValueError("Invalid value for `altitude`, must be a value greater than or equal to `-32767`")  # noqa: E501

        self._altitude = altitude

    @property
    def uncertainty_ellipse(self) -> UncertaintyEllipse:
        """Gets the uncertainty_ellipse of this PointAltitudeUncertainty.


        :return: The uncertainty_ellipse of this PointAltitudeUncertainty.
        :rtype: UncertaintyEllipse
        """
        return self._uncertainty_ellipse

    @uncertainty_ellipse.setter
    def uncertainty_ellipse(self, uncertainty_ellipse: UncertaintyEllipse):
        """Sets the uncertainty_ellipse of this PointAltitudeUncertainty.


        :param uncertainty_ellipse: The uncertainty_ellipse of this PointAltitudeUncertainty.
        :type uncertainty_ellipse: UncertaintyEllipse
        """
        if uncertainty_ellipse is None:
            raise ValueError("Invalid value for `uncertainty_ellipse`, must not be `None`")  # noqa: E501

        self._uncertainty_ellipse = uncertainty_ellipse

    @property
    def uncertainty_altitude(self) -> float:
        """Gets the uncertainty_altitude of this PointAltitudeUncertainty.

        Indicates value of uncertainty.  # noqa: E501

        :return: The uncertainty_altitude of this PointAltitudeUncertainty.
        :rtype: float
        """
        return self._uncertainty_altitude

    @uncertainty_altitude.setter
    def uncertainty_altitude(self, uncertainty_altitude: float):
        """Sets the uncertainty_altitude of this PointAltitudeUncertainty.

        Indicates value of uncertainty.  # noqa: E501

        :param uncertainty_altitude: The uncertainty_altitude of this PointAltitudeUncertainty.
        :type uncertainty_altitude: float
        """
        if uncertainty_altitude is None:
            raise ValueError("Invalid value for `uncertainty_altitude`, must not be `None`")  # noqa: E501
        if uncertainty_altitude is not None and uncertainty_altitude < 0:  # noqa: E501
            raise ValueError("Invalid value for `uncertainty_altitude`, must be a value greater than or equal to `0`")  # noqa: E501

        self._uncertainty_altitude = uncertainty_altitude

    @property
    def confidence(self) -> int:
        """Gets the confidence of this PointAltitudeUncertainty.

        Indicates value of confidence.  # noqa: E501

        :return: The confidence of this PointAltitudeUncertainty.
        :rtype: int
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence: int):
        """Sets the confidence of this PointAltitudeUncertainty.

        Indicates value of confidence.  # noqa: E501

        :param confidence: The confidence of this PointAltitudeUncertainty.
        :type confidence: int
        """
        if confidence is None:
            raise ValueError("Invalid value for `confidence`, must not be `None`")  # noqa: E501
        if confidence is not None and confidence > 100:  # noqa: E501
            raise ValueError("Invalid value for `confidence`, must be a value less than or equal to `100`")  # noqa: E501
        if confidence is not None and confidence < 0:  # noqa: E501
            raise ValueError("Invalid value for `confidence`, must be a value greater than or equal to `0`")  # noqa: E501

        self._confidence = confidence

    @property
    def v_confidence(self) -> int:
        """Gets the v_confidence of this PointAltitudeUncertainty.

        Indicates value of confidence.  # noqa: E501

        :return: The v_confidence of this PointAltitudeUncertainty.
        :rtype: int
        """
        return self._v_confidence

    @v_confidence.setter
    def v_confidence(self, v_confidence: int):
        """Sets the v_confidence of this PointAltitudeUncertainty.

        Indicates value of confidence.  # noqa: E501

        :param v_confidence: The v_confidence of this PointAltitudeUncertainty.
        :type v_confidence: int
        """
        if v_confidence is not None and v_confidence > 100:  # noqa: E501
            raise ValueError("Invalid value for `v_confidence`, must be a value less than or equal to `100`")  # noqa: E501
        if v_confidence is not None and v_confidence < 0:  # noqa: E501
            raise ValueError("Invalid value for `v_confidence`, must be a value greater than or equal to `0`")  # noqa: E501

        self._v_confidence = v_confidence
