#!/bin/bash
source $(dirname "$(readlink -f "$0")")/variables.sh

# Function to display a warning message
warning_message() {
    echo "WARNING: This uninstallation process is irreversible."
    echo "All data associated with Vault service will be permanently lost."
    echo "Are you sure you want to continue? (yes/no)"
}

# Display the warning message
warning_message

# Read the user input
read -r USER_INPUT

# Check if the user confirmed the uninstallation
if [ "$USER_INPUT" != "yes" ]; then
    echo "Uninstallation aborted by the user."
    exit 1
fi

# Proceed with the uninstallation process
echo "Proceeding with uninstallation..."

helm $KUBECONFIG uninstall $VAULT_SERVICE_NAME -n $VAULT_NAMESPACE
kubectl $KUBECONFIG delete job $VAULT_JOB_NAME  -n $VAULT_NAMESPACE || echo "No vault $VAULT_JOB_NAME job present"
kubectl $KUBECONFIG delete namespace $VAULT_NAMESPACE

echo "Uninstallation complete. The Vault service and all associated data have been removed."