#!/bin/bash
source $(dirname "$(readlink -f "$0")")/variables.sh

helm repo add grafana https://grafana.github.io/helm-charts

### download dependencies
helm $KUBECONFIG dependency build $HELM_DIR/capif/
  
### check ingress_ip.oneke and get ip from ingress-nginx-controller
kubectl $KUBECONFIG get svc -A | grep ingress-nginx-controller

helm $KUBECONFIG upgrade --install -n $CAPIF_NAMESPACE $CAPIF_NAME_VERSION_CHART $HELM_DIR/capif/ \
--set grafana.enabled=true \
--set grafana.ingress.enabled=true \
--set grafana.ingress.hosts[0].host=ocf-mon-$CAPIF_CI_ENV_ENDPOINT.$CAPIF_DOMAIN \
--set grafana.ingress.hosts[0].paths[0].path="/" \
--set grafana.ingress.hosts[0].paths[0].pathType="Prefix" \
--set grafana.env.prometheusUrl=$PROMETHEUS_URL \
--set grafana.env.tempoUrl="http://$CAPIF_NAME_VERSION_CHART-tempo:3100" \
--set grafana.persistence.storageClass=$CAPIF_STORAGE_CLASS \
--set grafana.persistence.storage=$CAPIF_GRAFANA_STORAGE_SIZE \
--set fluentbit.enabled=true \
--set loki.enabled=true \
--set loki.persistence.storageClass=$CAPIF_STORAGE_CLASS \
--set loki.persistence.storage=$CAPIF_LOKI_STORAGE_SIZE \
--set tempo.tempo.metricsGenerator.remoteWriteUrl=$PROMETHEUS_URL/api/v1/write \
--set otelcollector.enabled=true \
--set otelcollector.configMap.tempoEndpoint=$CAPIF_NAME_VERSION_CHART-tempo:4317 \
--set ocf-access-control-policy.image.repository=$CAPIF_DOCKER_REGISTRY/ocf-access-control-policy-api \
--set ocf-access-control-policy.image.tag=$CAPIF_IMAGE_TAG \
--set ocf-access-control-policy.image.env.capifHostname=$CAPIF_HOSTNAME \
--set ocf-access-control-policy.monitoring="true" \
--set ocf-access-control-policy.env.logLevel="DEBUG" \
--set ocf-api-invocation-logs.image.repository=$CAPIF_DOCKER_REGISTRY/ocf-logging-api-invocation-api \
--set ocf-api-invocation-logs.image.tag=$CAPIF_IMAGE_TAG \
--set ocf-api-invocation-logs.env.monitoring="true" \
--set ocf-api-invocation-logs.env.capifHostname=$CAPIF_HOSTNAME \
--set ocf-api-invocation-logs.env.vaultHostname=$VAULT_INTERNAL_HOSTNAME \
--set ocf-api-invocation-logs.env.vaultPort=$VAULT_PORT \
--set ocf-api-invocation-logs.env.vaultAccessToken=$VAULT_ACCESS_TOKEN \
--set ocf-api-invocation-logs.env.logLevel="DEBUG" \
--set ocf-api-invoker-management.image.repository=$CAPIF_DOCKER_REGISTRY/ocf-api-invoker-management-api \
--set ocf-api-invoker-management.image.tag=$CAPIF_IMAGE_TAG \
--set ocf-api-invoker-management.env.monitoring="true" \
--set ocf-api-invoker-management.env.vaultHostname=$VAULT_INTERNAL_HOSTNAME \
--set ocf-api-invoker-management.env.vaultPort=$VAULT_PORT \
--set ocf-api-invoker-management.env.vaultAccessToken=$VAULT_ACCESS_TOKEN \
--set ocf-api-invoker-management.env.logLevel="DEBUG" \
--set ocf-api-provider-management.image.repository=$CAPIF_DOCKER_REGISTRY/ocf-api-provider-management-api \
--set ocf-api-provider-management.image.tag=$CAPIF_IMAGE_TAG \
--set ocf-api-provider-management.env.monitoring="true" \
--set ocf-api-provider-management.env.vaultHostname=$VAULT_INTERNAL_HOSTNAME \
--set ocf-api-provider-management.env.logLevel="DEBUG" \
--set ocf-api-provider-management.env.vaultPort=$VAULT_PORT \
--set ocf-api-provider-management.env.vaultAccessToken=$VAULT_ACCESS_TOKEN \
--set ocf-events.image.repository=$CAPIF_DOCKER_REGISTRY/ocf-events-api \
--set ocf-events.image.tag=$CAPIF_IMAGE_TAG \
--set ocf-events.env.monitoring="true" \
--set ocf-events.env.logLevel="DEBUG" \
--set ocf-routing-info.image.repository=$CAPIF_DOCKER_REGISTRY/ocf-routing-info-api \
--set ocf-routing-info.image.tag=$CAPIF_IMAGE_TAG \
--set ocf-routing-info.env.monitoring="true" \
--set ocf-routing-info.env.logLevel="DEBUG" \
--set ocf-security.image.repository=$CAPIF_DOCKER_REGISTRY/ocf-security-api \
--set ocf-security.image.tag=$CAPIF_IMAGE_TAG \
--set ocf-security.env.monitoring="true" \
--set ocf-security.env.capifHostname=$CAPIF_HOSTNAME \
--set ocf-security.env.vaultHostname=$VAULT_INTERNAL_HOSTNAME \
--set ocf-security.env.vaultPort=$VAULT_PORT \
--set ocf-security.env.vaultAccessToken=$VAULT_ACCESS_TOKEN \
--set ocf-security.env.logLevel="DEBUG" \
--set ocf-register.image.repository=$CAPIF_DOCKER_REGISTRY/register \
--set ocf-register.image.tag=$CAPIF_IMAGE_TAG \
--set ocf-register.env.vaultHostname=$VAULT_INTERNAL_HOSTNAME \
--set ocf-register.env.vaultAccessToken=$VAULT_ACCESS_TOKEN \
--set ocf-register.env.vaultPort=$VAULT_PORT \
--set ocf-register.env.mongoHost=mongo-register \
--set ocf-register.env.mongoPort=27017 \
--set ocf-register.env.capifHostname=$CAPIF_HOSTNAME \
--set ocf-register.ingress.enabled=true \
--set ocf-register.ingress.hosts[0].host=$REGISTER_HOSTNAME \
--set ocf-register.ingress.hosts[0].paths[0].path="/" \
--set ocf-register.ingress.hosts[0].paths[0].pathType="Prefix" \
--set ocf-register.env.logLevel="DEBUG" \
--set ocf-register.extraConfigPod.hostAliases[0].hostnames[0]=$CAPIF_HOSTNAME \
--set ocf-register.extraConfigPod.hostAliases[0].ip=$K8S_IP \
--set ocf-auditing-api-logs.image.repository=$CAPIF_DOCKER_REGISTRY/ocf-auditing-api \
--set ocf-auditing-api-logs.image.tag=$CAPIF_IMAGE_TAG \
--set ocf-auditing-api-logs.env.monitoring="true" \
--set ocf-auditing-api-logs.env.logLevel="DEBUG" \
--set ocf-publish-service-api.image.repository=$CAPIF_DOCKER_REGISTRY/ocf-publish-service-api \
--set ocf-publish-service-api.image.tag=$CAPIF_IMAGE_TAG \
--set ocf-publish-service-api.env.monitoring="true" \
--set ocf-publish-service-api.env.logLevel="DEBUG" \
--set ocf-discover-service-api.image.repository=$CAPIF_DOCKER_REGISTRY/ocf-discover-service-api \
--set ocf-discover-service-api.image.tag=$CAPIF_IMAGE_TAG \
--set ocf-discover-service-api.env.monitoring="true" \
--set ocf-discover-service-api.env.logLevel="DEBUG" \
--set nginx.image.repository=$CAPIF_DOCKER_REGISTRY/nginx \
--set nginx.image.tag=$CAPIF_IMAGE_TAG \
--set nginx.env.capifHostname=$CAPIF_HOSTNAME \
--set nginx.env.vaultHostname=$VAULT_INTERNAL_HOSTNAME \
--set nginx.env.vaultPort=$VAULT_PORT \
--set nginx.env.vaultAccessToken=$VAULT_ACCESS_TOKEN \
--set nginx.ingress.enabled=true \
--set nginx.ingress.hosts[0].host=$CAPIF_HOSTNAME \
--set nginx.ingress.hosts[0].paths[0].path="/" \
--set nginx.ingress.hosts[0].paths[0].pathType="Prefix" \
--set nginx.env.logLevel="debug" \
--set ocf-helper.image.repository=$CAPIF_DOCKER_REGISTRY/helper \
--set ocf-helper.image.tag=$CAPIF_IMAGE_TAG \
--set ocf-helper.env.vaultHostname=$VAULT_INTERNAL_HOSTNAME \
--set ocf-helper.env.vaultPort=$VAULT_PORT \
--set ocf-helper.env.vaultAccessToken=$VAULT_ACCESS_TOKEN \
--set ocf-helper.env.capifHostname=$CAPIF_HOSTNAME \
--set ocf-helper.env.logLevel="DEBUG" \
--set mock-server.enabled=true \
--set mock-server.image.repository=$CAPIF_DOCKER_REGISTRY/mock-server \
--set mock-server.image.tag=$CAPIF_IMAGE_TAG \
--set mock-server.ingress.enabled=true \
--set mock-server.ingress.hosts[0].host=mock-server-$CAPIF_CI_ENV_ENDPOINT.$CAPIF_DOMAIN \
--set mock-server.ingress.hosts[0].paths[0].path="/" \
--set mock-server.ingress.hosts[0].paths[0].pathType="Prefix" \
--set mock-server.env.logLevel="DEBUG" \
--set mongo-register.persistence.storageClass=$CAPIF_STORAGE_CLASS \
--set mongo-register.persistence.storage=$CAPIF_MONGO_REGISTER_STORAGE_SIZE \
--set mongo-register.extraFlags[0]="--repair" \
--set mongo-register-express.enabled=true \
--set mongo-register-express.ingress.enabled=true \
--set mongo-register-express.ingress.hosts[0].host="mongo-express-register-$CAPIF_CI_ENV_ENDPOINT.$CAPIF_DOMAIN" \
--set mongo-register-express.ingress.hosts[0].paths[0].path="/" \
--set mongo-register-express.ingress.hosts[0].paths[0].pathType="Prefix" \
--set mongo.persistence.storageClass=$CAPIF_STORAGE_CLASS \
--set mongo.persistence.storage=$CAPIF_MONGO_STORAGE_SIZE \
--set mongo.extraFlags[0]="--repair" \
--set mongo-express.enabled=true \
--set mongo-express.ingress.enabled=true \
--set mongo-express.ingress.hosts[0].host="mongo-express-$CAPIF_CI_ENV_ENDPOINT.$CAPIF_DOMAIN" \
--set mongo-express.ingress.hosts[0].paths[0].path="/" \
--set mongo-express.ingress.hosts[0].paths[0].pathType="Prefix" \
--wait --timeout=10m --create-namespace --atomic $CAPIF_RESOURCES $CAPIF_STORAGE_ACCESS_MODE $CAPIF_RUN_AS_USER_CONFIG
