# Helm monitoring stack

![Version: 1.0.0](https://img.shields.io/badge/Version-1.0.0-informational?style=flat-square) ![Type: application](https://img.shields.io/badge/Type-application-informational?style=flat-square) ![AppVersion: 1.0.0](https://img.shields.io/badge/AppVersion-1.0.0-informational?style=flat-square)

A Helm chart for Kubernetes monitoring stack

## Requirements

```
$ helm dependency build helm-monitoring-stack/
$ helm upgrade --install -n monitoring monitoring helm-monitoring-stack/ --create-namespace
```


| Repository | Name | Version |
|------------|------|---------|
|  | grafana |  |
|  | prometheus |  |
|  | skooner |  |
| https://charts.bitnami.com/bitnami | metrics-server | 6.9.3 |

## Values

| Key | Type | Default | Description |
|-----|------|---------|-------------|
| grafana.hosts[0].host | string | `"grafana-dt.tactile5g.int"` |  |
| grafana.hosts[0].paths[0].path | string | `"/"` |  |
| grafana.hosts[0].paths[0].pathType | string | `"Prefix"` |  |
| grafana.ingress.enable | bool | `true` |  |
| metrics-server.apiService.create | bool | `true` |  |
| metrics-server.extraArgs[0] | string | `"--kubelet-insecure-tls=true"` |  |
| metrics-server.extraArgs[1] | string | `"--kubelet-preferred-address-types=InternalIP"` |  |
| prometheus.hosts[0].host | string | `"prometheus-dt.tactile5g.int"` |  |
| prometheus.hosts[0].paths[0].path | string | `"/"` |  |
| prometheus.hosts[0].paths[0].pathType | string | `"Prefix"` |  |
| prometheus.ingress.enabled | bool | `true` |  |
| skooner.hosts[0].host | string | `"skooner.tactile5g.com"` |  |
| skooner.hosts[0].paths[0].path | string | `"/"` |  |
| skooner.hosts[0].paths[0].pathType | string | `"Prefix"` |  |
| skooner.ingress.enabled | bool | `true` |  |

----------------------------------------------
Autogenerated from chart metadata using [helm-docs v1.13.1](https://github.com/norwoodj/helm-docs/releases/v1.13.1)
