
# docker-compose -f "docker-compose-capif.yml" down  --rmi all --remove-orphans
# docker network rm capif-network

# status=$?
# if [ $status -eq 0 ]; then
#     echo "*** All Capif services are cleaned ***"
# else
#     echo "*** Some Capif services failed on clean ***"
# fi

# exit $status

#!/bin/bash

# Verificar el parámetro proporcionado
if [[ $# -eq 0 || "$1" == "capif" ]]; then
  FILES=("docker-compose-capif.yml")
elif [[ "$1" == "all" ]]; then
  FILES=("docker-compose-capif.yml" "docker-compose-vault.yml" "docker-compose-register.yml" "../monitoring/docker-compose.yml" "docker-compose-backoffice.yml")
else
  echo "Parámetro inválido. Uso: ./script.sh [capif|all]"
  exit 1
fi

# Recorrer los archivos Docker Compose y ejecutar docker-compose down
for FILE in "${FILES[@]}"; do
  echo "Ejecutando 'docker-compose down' para el archivo $FILE"
  docker-compose -f "$FILE" down --rmi all
  status=$?
    if [ $status -eq 0 ]; then
        echo "*** Removed Service from $FILE ***"
    else
        echo "*** Some services of $FILE failed on clean ***"
    fi
done

docker network rm capif-network

echo "Operación completada."
