# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from capif_events.models.base_model_ import Model
from capif_events import util


class CAPIFEventFilter(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, api_ids=None, api_invoker_ids=None, aef_ids=None):  # noqa: E501
        """CAPIFEventFilter - a model defined in OpenAPI

        :param api_ids: The api_ids of this CAPIFEventFilter.  # noqa: E501
        :type api_ids: List[str]
        :param api_invoker_ids: The api_invoker_ids of this CAPIFEventFilter.  # noqa: E501
        :type api_invoker_ids: List[str]
        :param aef_ids: The aef_ids of this CAPIFEventFilter.  # noqa: E501
        :type aef_ids: List[str]
        """
        self.openapi_types = {
            'api_ids': List[str],
            'api_invoker_ids': List[str],
            'aef_ids': List[str]
        }

        self.attribute_map = {
            'api_ids': 'apiIds',
            'api_invoker_ids': 'apiInvokerIds',
            'aef_ids': 'aefIds'
        }

        self._api_ids = api_ids
        self._api_invoker_ids = api_invoker_ids
        self._aef_ids = aef_ids

    @classmethod
    def from_dict(cls, dikt) -> 'CAPIFEventFilter':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The CAPIFEventFilter of this CAPIFEventFilter.  # noqa: E501
        :rtype: CAPIFEventFilter
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api_ids(self):
        """Gets the api_ids of this CAPIFEventFilter.

        Identifier of the service API  # noqa: E501

        :return: The api_ids of this CAPIFEventFilter.
        :rtype: List[str]
        """
        return self._api_ids

    @api_ids.setter
    def api_ids(self, api_ids):
        """Sets the api_ids of this CAPIFEventFilter.

        Identifier of the service API  # noqa: E501

        :param api_ids: The api_ids of this CAPIFEventFilter.
        :type api_ids: List[str]
        """
        if api_ids is not None and len(api_ids) < 1:
            raise ValueError("Invalid value for `api_ids`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._api_ids = api_ids

    @property
    def api_invoker_ids(self):
        """Gets the api_invoker_ids of this CAPIFEventFilter.

        Identity of the API invoker  # noqa: E501

        :return: The api_invoker_ids of this CAPIFEventFilter.
        :rtype: List[str]
        """
        return self._api_invoker_ids

    @api_invoker_ids.setter
    def api_invoker_ids(self, api_invoker_ids):
        """Sets the api_invoker_ids of this CAPIFEventFilter.

        Identity of the API invoker  # noqa: E501

        :param api_invoker_ids: The api_invoker_ids of this CAPIFEventFilter.
        :type api_invoker_ids: List[str]
        """
        if api_invoker_ids is not None and len(api_invoker_ids) < 1:
            raise ValueError("Invalid value for `api_invoker_ids`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._api_invoker_ids = api_invoker_ids

    @property
    def aef_ids(self):
        """Gets the aef_ids of this CAPIFEventFilter.

        Identifier of the API exposing function  # noqa: E501

        :return: The aef_ids of this CAPIFEventFilter.
        :rtype: List[str]
        """
        return self._aef_ids

    @aef_ids.setter
    def aef_ids(self, aef_ids):
        """Sets the aef_ids of this CAPIFEventFilter.

        Identifier of the API exposing function  # noqa: E501

        :param aef_ids: The aef_ids of this CAPIFEventFilter.
        :type aef_ids: List[str]
        """
        if aef_ids is not None and len(aef_ids) < 1:
            raise ValueError("Invalid value for `aef_ids`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._aef_ids = aef_ids
