#!/bin/bash
source $(dirname "$(readlink -f "$0")")/variables.sh

helm repo add bitnami https://charts.bitnami.com/bitnami

helm $KUBECONFIG dependency build $HELM_DIR/monitoring-stack/

helm $KUBECONFIG upgrade --install -n $MONITORING_NAMESPACE $MONITORING_SERVICE_NAME $HELM_DIR/monitoring-stack/ \
--set grafana.enabled=false \
--set grafana.env.prometheusUrl=$PROMETHEUS_URL \
--set prometheus.enabled=true \
--set prometheus.ingress.enabled=true \
--set prometheus.ingress.hosts[0].host=$PROMETHEUS_HOSTNAME \
--set prometheus.ingress.hosts[0].paths[0].path="/" \
--set prometheus.ingress.hosts[0].paths[0].pathType="Prefix" \
--wait --timeout=10m --create-namespace --atomic

