from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from capif_events import util
from capif_events.models.base_model import Model
from capif_events.models.interface_description import InterfaceDescription  # noqa: E501
from capif_events.models.operation import Operation  # noqa: E501
from capif_events.models.protocol import Protocol  # noqa: E501


class Log(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, api_id=None, api_name=None, api_version=None, resource_name=None, uri=None, protocol=None, operation=None, result=None, invocation_time=None, invocation_latency=None, input_parameters=None, output_parameters=None, src_interface=None, dest_interface=None, fwd_interface=None):  # noqa: E501
        """Log - a model defined in OpenAPI

        :param api_id: The api_id of this Log.  # noqa: E501
        :type api_id: str
        :param api_name: The api_name of this Log.  # noqa: E501
        :type api_name: str
        :param api_version: The api_version of this Log.  # noqa: E501
        :type api_version: str
        :param resource_name: The resource_name of this Log.  # noqa: E501
        :type resource_name: str
        :param uri: The uri of this Log.  # noqa: E501
        :type uri: str
        :param protocol: The protocol of this Log.  # noqa: E501
        :type protocol: Protocol
        :param operation: The operation of this Log.  # noqa: E501
        :type operation: Operation
        :param result: The result of this Log.  # noqa: E501
        :type result: str
        :param invocation_time: The invocation_time of this Log.  # noqa: E501
        :type invocation_time: datetime
        :param invocation_latency: The invocation_latency of this Log.  # noqa: E501
        :type invocation_latency: int
        :param input_parameters: The input_parameters of this Log.  # noqa: E501
        :type input_parameters: object
        :param output_parameters: The output_parameters of this Log.  # noqa: E501
        :type output_parameters: object
        :param src_interface: The src_interface of this Log.  # noqa: E501
        :type src_interface: InterfaceDescription
        :param dest_interface: The dest_interface of this Log.  # noqa: E501
        :type dest_interface: InterfaceDescription
        :param fwd_interface: The fwd_interface of this Log.  # noqa: E501
        :type fwd_interface: str
        """
        self.openapi_types = {
            'api_id': str,
            'api_name': str,
            'api_version': str,
            'resource_name': str,
            'uri': str,
            'protocol': Protocol,
            'operation': Operation,
            'result': str,
            'invocation_time': datetime,
            'invocation_latency': int,
            'input_parameters': object,
            'output_parameters': object,
            'src_interface': InterfaceDescription,
            'dest_interface': InterfaceDescription,
            'fwd_interface': str
        }

        self.attribute_map = {
            'api_id': 'apiId',
            'api_name': 'apiName',
            'api_version': 'apiVersion',
            'resource_name': 'resourceName',
            'uri': 'uri',
            'protocol': 'protocol',
            'operation': 'operation',
            'result': 'result',
            'invocation_time': 'invocationTime',
            'invocation_latency': 'invocationLatency',
            'input_parameters': 'inputParameters',
            'output_parameters': 'outputParameters',
            'src_interface': 'srcInterface',
            'dest_interface': 'destInterface',
            'fwd_interface': 'fwdInterface'
        }

        self._api_id = api_id
        self._api_name = api_name
        self._api_version = api_version
        self._resource_name = resource_name
        self._uri = uri
        self._protocol = protocol
        self._operation = operation
        self._result = result
        self._invocation_time = invocation_time
        self._invocation_latency = invocation_latency
        self._input_parameters = input_parameters
        self._output_parameters = output_parameters
        self._src_interface = src_interface
        self._dest_interface = dest_interface
        self._fwd_interface = fwd_interface

    @classmethod
    def from_dict(cls, dikt) -> 'Log':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Log of this Log.  # noqa: E501
        :rtype: Log
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api_id(self) -> str:
        """Gets the api_id of this Log.

        String identifying the API invoked.  # noqa: E501

        :return: The api_id of this Log.
        :rtype: str
        """
        return self._api_id

    @api_id.setter
    def api_id(self, api_id: str):
        """Sets the api_id of this Log.

        String identifying the API invoked.  # noqa: E501

        :param api_id: The api_id of this Log.
        :type api_id: str
        """
        if api_id is None:
            raise ValueError("Invalid value for `api_id`, must not be `None`")  # noqa: E501

        self._api_id = api_id

    @property
    def api_name(self) -> str:
        """Gets the api_name of this Log.

        Name of the API which was invoked, it is set as {apiName} part of the URI structure as defined in clause 5.2.4 of 3GPP TS 29.122.   # noqa: E501

        :return: The api_name of this Log.
        :rtype: str
        """
        return self._api_name

    @api_name.setter
    def api_name(self, api_name: str):
        """Sets the api_name of this Log.

        Name of the API which was invoked, it is set as {apiName} part of the URI structure as defined in clause 5.2.4 of 3GPP TS 29.122.   # noqa: E501

        :param api_name: The api_name of this Log.
        :type api_name: str
        """
        if api_name is None:
            raise ValueError("Invalid value for `api_name`, must not be `None`")  # noqa: E501

        self._api_name = api_name

    @property
    def api_version(self) -> str:
        """Gets the api_version of this Log.

        Version of the API which was invoked  # noqa: E501

        :return: The api_version of this Log.
        :rtype: str
        """
        return self._api_version

    @api_version.setter
    def api_version(self, api_version: str):
        """Sets the api_version of this Log.

        Version of the API which was invoked  # noqa: E501

        :param api_version: The api_version of this Log.
        :type api_version: str
        """
        if api_version is None:
            raise ValueError("Invalid value for `api_version`, must not be `None`")  # noqa: E501

        self._api_version = api_version

    @property
    def resource_name(self) -> str:
        """Gets the resource_name of this Log.

        Name of the specific resource invoked  # noqa: E501

        :return: The resource_name of this Log.
        :rtype: str
        """
        return self._resource_name

    @resource_name.setter
    def resource_name(self, resource_name: str):
        """Sets the resource_name of this Log.

        Name of the specific resource invoked  # noqa: E501

        :param resource_name: The resource_name of this Log.
        :type resource_name: str
        """
        if resource_name is None:
            raise ValueError("Invalid value for `resource_name`, must not be `None`")  # noqa: E501

        self._resource_name = resource_name

    @property
    def uri(self) -> str:
        """Gets the uri of this Log.

        string providing an URI formatted according to IETF RFC 3986.  # noqa: E501

        :return: The uri of this Log.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri: str):
        """Sets the uri of this Log.

        string providing an URI formatted according to IETF RFC 3986.  # noqa: E501

        :param uri: The uri of this Log.
        :type uri: str
        """

        self._uri = uri

    @property
    def protocol(self) -> Protocol:
        """Gets the protocol of this Log.


        :return: The protocol of this Log.
        :rtype: Protocol
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol: Protocol):
        """Sets the protocol of this Log.


        :param protocol: The protocol of this Log.
        :type protocol: Protocol
        """
        if protocol is None:
            raise ValueError("Invalid value for `protocol`, must not be `None`")  # noqa: E501

        self._protocol = protocol

    @property
    def operation(self) -> Operation:
        """Gets the operation of this Log.


        :return: The operation of this Log.
        :rtype: Operation
        """
        return self._operation

    @operation.setter
    def operation(self, operation: Operation):
        """Sets the operation of this Log.


        :param operation: The operation of this Log.
        :type operation: Operation
        """

        self._operation = operation

    @property
    def result(self) -> str:
        """Gets the result of this Log.

        For HTTP protocol, it contains HTTP status code of the invocation  # noqa: E501

        :return: The result of this Log.
        :rtype: str
        """
        return self._result

    @result.setter
    def result(self, result: str):
        """Sets the result of this Log.

        For HTTP protocol, it contains HTTP status code of the invocation  # noqa: E501

        :param result: The result of this Log.
        :type result: str
        """
        if result is None:
            raise ValueError("Invalid value for `result`, must not be `None`")  # noqa: E501

        self._result = result

    @property
    def invocation_time(self) -> datetime:
        """Gets the invocation_time of this Log.

        string with format \"date-time\" as defined in OpenAPI.  # noqa: E501

        :return: The invocation_time of this Log.
        :rtype: datetime
        """
        return self._invocation_time

    @invocation_time.setter
    def invocation_time(self, invocation_time: datetime):
        """Sets the invocation_time of this Log.

        string with format \"date-time\" as defined in OpenAPI.  # noqa: E501

        :param invocation_time: The invocation_time of this Log.
        :type invocation_time: datetime
        """

        self._invocation_time = invocation_time

    @property
    def invocation_latency(self) -> int:
        """Gets the invocation_latency of this Log.

        Represents a period of time in units of milliseconds.  # noqa: E501

        :return: The invocation_latency of this Log.
        :rtype: int
        """
        return self._invocation_latency

    @invocation_latency.setter
    def invocation_latency(self, invocation_latency: int):
        """Sets the invocation_latency of this Log.

        Represents a period of time in units of milliseconds.  # noqa: E501

        :param invocation_latency: The invocation_latency of this Log.
        :type invocation_latency: int
        """
        if invocation_latency is not None and invocation_latency < 0:  # noqa: E501
            raise ValueError("Invalid value for `invocation_latency`, must be a value greater than or equal to `0`")  # noqa: E501

        self._invocation_latency = invocation_latency

    @property
    def input_parameters(self) -> object:
        """Gets the input_parameters of this Log.

        List of input parameters. Can be any value - string, number, boolean, array or object.   # noqa: E501

        :return: The input_parameters of this Log.
        :rtype: object
        """
        return self._input_parameters

    @input_parameters.setter
    def input_parameters(self, input_parameters: object):
        """Sets the input_parameters of this Log.

        List of input parameters. Can be any value - string, number, boolean, array or object.   # noqa: E501

        :param input_parameters: The input_parameters of this Log.
        :type input_parameters: object
        """

        self._input_parameters = input_parameters

    @property
    def output_parameters(self) -> object:
        """Gets the output_parameters of this Log.

        List of output parameters. Can be any value - string, number, boolean, array or object.   # noqa: E501

        :return: The output_parameters of this Log.
        :rtype: object
        """
        return self._output_parameters

    @output_parameters.setter
    def output_parameters(self, output_parameters: object):
        """Sets the output_parameters of this Log.

        List of output parameters. Can be any value - string, number, boolean, array or object.   # noqa: E501

        :param output_parameters: The output_parameters of this Log.
        :type output_parameters: object
        """

        self._output_parameters = output_parameters

    @property
    def src_interface(self) -> InterfaceDescription:
        """Gets the src_interface of this Log.


        :return: The src_interface of this Log.
        :rtype: InterfaceDescription
        """
        return self._src_interface

    @src_interface.setter
    def src_interface(self, src_interface: InterfaceDescription):
        """Sets the src_interface of this Log.


        :param src_interface: The src_interface of this Log.
        :type src_interface: InterfaceDescription
        """

        self._src_interface = src_interface

    @property
    def dest_interface(self) -> InterfaceDescription:
        """Gets the dest_interface of this Log.


        :return: The dest_interface of this Log.
        :rtype: InterfaceDescription
        """
        return self._dest_interface

    @dest_interface.setter
    def dest_interface(self, dest_interface: InterfaceDescription):
        """Sets the dest_interface of this Log.


        :param dest_interface: The dest_interface of this Log.
        :type dest_interface: InterfaceDescription
        """

        self._dest_interface = dest_interface

    @property
    def fwd_interface(self) -> str:
        """Gets the fwd_interface of this Log.

        It includes the node identifier (as defined in IETF RFC 7239 of all forwarding entities between the API invoker and the AEF, concatenated with comma and space, e.g. 192.0.2.43:80, unknown:_OBFport, 203.0.113.60   # noqa: E501

        :return: The fwd_interface of this Log.
        :rtype: str
        """
        return self._fwd_interface

    @fwd_interface.setter
    def fwd_interface(self, fwd_interface: str):
        """Sets the fwd_interface of this Log.

        It includes the node identifier (as defined in IETF RFC 7239 of all forwarding entities between the API invoker and the AEF, concatenated with comma and space, e.g. 192.0.2.43:80, unknown:_OBFport, 203.0.113.60   # noqa: E501

        :param fwd_interface: The fwd_interface of this Log.
        :type fwd_interface: str
        """

        self._fwd_interface = fwd_interface
