#!/bin/bash

# Directories variables setup (no modification needed)
export SERVICES_DIR=$(dirname "$(readlink -f "$0")")
export CAPIF_BASE_DIR=$(dirname "$SERVICES_DIR")

help() {
  echo "Usage: $1 <options>"
  echo "       -i : Setup different host ip for mock server (default 0.0.0.0)"
  echo "       -p : Setup different port for mock server (default 9090)"
  echo "       -h : show this help"
  exit 1
}

IP=0.0.0.0
PORT=9090

# Read params
while getopts ":i:p:h" opt; do
  case $opt in
    i)
      IP="$OPTARG"
      ;;
    p)
      PORT=$OPTARG
      ;;
    h)
      help
      ;;  
    \?)
      echo "Not valid option: -$OPTARG" >&2
      help
      ;;
    :)
      echo "The -$OPTARG option requires an argument." >&2
      help
      ;;
  esac
done

echo Robot Framework Mock Server will listen on $IP:$PORT

docker network create capif-network || echo "capif-network previously created on docker networks"

IP=$IP PORT=$PORT docker compose -f "$SERVICES_DIR/docker-compose-mock-server.yml" up --detach --build

status=$?
if [ $status -eq 0 ]; then
    echo "*** All Capif services are running ***"
else
    echo "*** Some Capif services failed to start ***"
    exit $status
fi
