from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from service_apis.models.base_model import Model
from service_apis import util


class ApiStatus(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, aef_ids=None):  # noqa: E501
        """ApiStatus - a model defined in OpenAPI

        :param aef_ids: The aef_ids of this ApiStatus.  # noqa: E501
        :type aef_ids: List[str]
        """
        self.openapi_types = {
            'aef_ids': List[str]
        }

        self.attribute_map = {
            'aef_ids': 'aefIds'
        }

        self._aef_ids = aef_ids

    @classmethod
    def from_dict(cls, dikt) -> 'ApiStatus':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ApiStatus of this ApiStatus.  # noqa: E501
        :rtype: ApiStatus
        """
        return util.deserialize_model(dikt, cls)

    @property
    def aef_ids(self) -> List[str]:
        """Gets the aef_ids of this ApiStatus.

        Indicates the list of AEF ID(s) where the API is active. If this attribute is omitted, the API is inactive at all AEF(s) defined in the \"aefProfiles\" attribute within the ServiceAPIDescription data structure.   # noqa: E501

        :return: The aef_ids of this ApiStatus.
        :rtype: List[str]
        """
        return self._aef_ids

    @aef_ids.setter
    def aef_ids(self, aef_ids: List[str]):
        """Sets the aef_ids of this ApiStatus.

        Indicates the list of AEF ID(s) where the API is active. If this attribute is omitted, the API is inactive at all AEF(s) defined in the \"aefProfiles\" attribute within the ServiceAPIDescription data structure.   # noqa: E501

        :param aef_ids: The aef_ids of this ApiStatus.
        :type aef_ids: List[str]
        """
        if aef_ids is None:
            raise ValueError("Invalid value for `aef_ids`, must not be `None`")  # noqa: E501

        self._aef_ids = aef_ids
