from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from capif_events import util
from capif_events.models.base_model import Model
from capif_events.models.capif_event import CAPIFEvent  # noqa: E501
from capif_events.models.capif_event_filter import CAPIFEventFilter  # noqa: E501
from capif_events.models.reporting_information import ReportingInformation  # noqa: E501


class EventSubscriptionPatch(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, events=None, event_filters=None, event_req=None, notification_destination=None):  # noqa: E501
        """EventSubscriptionPatch - a model defined in OpenAPI

        :param events: The events of this EventSubscriptionPatch.  # noqa: E501
        :type events: List[CAPIFEvent]
        :param event_filters: The event_filters of this EventSubscriptionPatch.  # noqa: E501
        :type event_filters: List[CAPIFEventFilter]
        :param event_req: The event_req of this EventSubscriptionPatch.  # noqa: E501
        :type event_req: ReportingInformation
        :param notification_destination: The notification_destination of this EventSubscriptionPatch.  # noqa: E501
        :type notification_destination: str
        """
        self.openapi_types = {
            'events': List[CAPIFEvent],
            'event_filters': List[CAPIFEventFilter],
            'event_req': ReportingInformation,
            'notification_destination': str
        }

        self.attribute_map = {
            'events': 'events',
            'event_filters': 'eventFilters',
            'event_req': 'eventReq',
            'notification_destination': 'notificationDestination'
        }

        self._events = events
        self._event_filters = event_filters
        self._event_req = event_req
        self._notification_destination = notification_destination

    @classmethod
    def from_dict(cls, dikt) -> 'EventSubscriptionPatch':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The EventSubscriptionPatch of this EventSubscriptionPatch.  # noqa: E501
        :rtype: EventSubscriptionPatch
        """
        return util.deserialize_model(dikt, cls)

    @property
    def events(self) -> List[CAPIFEvent]:
        """Gets the events of this EventSubscriptionPatch.

        Subscribed events  # noqa: E501

        :return: The events of this EventSubscriptionPatch.
        :rtype: List[CAPIFEvent]
        """
        return self._events

    @events.setter
    def events(self, events: List[CAPIFEvent]):
        """Sets the events of this EventSubscriptionPatch.

        Subscribed events  # noqa: E501

        :param events: The events of this EventSubscriptionPatch.
        :type events: List[CAPIFEvent]
        """
        if events is not None and len(events) < 1:
            raise ValueError("Invalid value for `events`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._events = events

    @property
    def event_filters(self) -> List[CAPIFEventFilter]:
        """Gets the event_filters of this EventSubscriptionPatch.

        Subscribed event filters  # noqa: E501

        :return: The event_filters of this EventSubscriptionPatch.
        :rtype: List[CAPIFEventFilter]
        """
        return self._event_filters

    @event_filters.setter
    def event_filters(self, event_filters: List[CAPIFEventFilter]):
        """Sets the event_filters of this EventSubscriptionPatch.

        Subscribed event filters  # noqa: E501

        :param event_filters: The event_filters of this EventSubscriptionPatch.
        :type event_filters: List[CAPIFEventFilter]
        """
        if event_filters is not None and len(event_filters) < 1:
            raise ValueError("Invalid value for `event_filters`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._event_filters = event_filters

    @property
    def event_req(self) -> ReportingInformation:
        """Gets the event_req of this EventSubscriptionPatch.


        :return: The event_req of this EventSubscriptionPatch.
        :rtype: ReportingInformation
        """
        return self._event_req

    @event_req.setter
    def event_req(self, event_req: ReportingInformation):
        """Sets the event_req of this EventSubscriptionPatch.


        :param event_req: The event_req of this EventSubscriptionPatch.
        :type event_req: ReportingInformation
        """

        self._event_req = event_req

    @property
    def notification_destination(self) -> str:
        """Gets the notification_destination of this EventSubscriptionPatch.

        string providing an URI formatted according to IETF RFC 3986.  # noqa: E501

        :return: The notification_destination of this EventSubscriptionPatch.
        :rtype: str
        """
        return self._notification_destination

    @notification_destination.setter
    def notification_destination(self, notification_destination: str):
        """Sets the notification_destination of this EventSubscriptionPatch.

        string providing an URI formatted according to IETF RFC 3986.  # noqa: E501

        :param notification_destination: The notification_destination of this EventSubscriptionPatch.
        :type notification_destination: str
        """

        self._notification_destination = notification_destination
