#!/bin/bash
source $(dirname "$(readlink -f "$0")")/variables.sh

# Function to display a warning message
warning_message() {
    echo "WARNING: This uninstallation process is irreversible."
    echo "All data associated with CAPIF service will be permanently lost."
    echo "Are you sure you want to continue? (yes/no)"
}

# Display the warning message
warning_message

# Read the user input
read -r USER_INPUT

# Check if the user confirmed the uninstallation
if [ "$USER_INPUT" != "yes" ]; then
    echo "Uninstallation aborted by the user."
    exit 1
fi

# Proceed with the uninstallation process
echo "Proceeding with uninstallation..."

helm $KUBECONFIG uninstall $CAPIF_NAME_VERSION_CHART -n $CAPIF_NAMESPACE || echo "$CAPIF_NAME_VERSION_CHART is not present"
kubectl $KUBECONFIG delete namespace $CAPIF_NAMESPACE || echo "$CAPIF_NAMESPACE is not present"

echo "Uninstallation complete. The CAPIF service and all associated data have been removed."