#import concurrent
import requests
from .internal_event_ops import InternalEventOperations
from ..models.event_notification import EventNotification
from ..models.access_control_policy_list_ext import AccessControlPolicyListExt
from ..models.capif_event_detail import CAPIFEventDetail
from ..encoder import JSONEncoder
import sys
import json
from flask import current_app
import asyncio
import aiohttp

class Notifications():

    def __init__(self):
        self.events_ops = InternalEventOperations()

    def send_notifications(self, event):
        current_app.logger.info("Received event, sending notifications")
        subscriptions = self.events_ops.get_event_subscriptions(event)
        # message, *ids = event.split(":")

        try:
            for sub in subscriptions:
                url = sub["notification_destination"]
                data = EventNotification(sub["subscription_id"], events=event)
                # details = CAPIFEventDetail()
                # if message == "ACCESS_CONTROL_POLICY_UPDATE":
                #     current_app.logger.info("event: ACCESS_CONTROL_POLICY_UPDATE")
                #     acls = self.events_ops.get_acls(ids[0])
                #     details.acc_ctrl_pol_list = AccessControlPolicyListExt(api_id=acls['service_id'], api_invoker_policies=acls['apiInvokerPolicies'])

                # data.event_detail=details
                self.request_post(url, data)
                #current_app.logger.info("notification sended")

        except Exception as e:
            current_app.logger.error("An exception occurred ::" + str(e))
            return False

    def send_notifications_new(self, redis_event):
        try:
            if redis_event.get('event', None) == None:
                raise("Event value is not present on received event from REDIS")
            
            current_app.logger.info("Received event " + redis_event.get('event') + ", sending notifications")
            subscriptions = self.events_ops.get_event_subscriptions(redis_event.get('event'))
            # message, *ids = event.split(":")
            current_app.logger.info(subscriptions)

            for sub in subscriptions:
                url = sub["notification_destination"]
                current_app.logger.debug(url)
                event_detail=None
                if redis_event.get('key', None) != None and redis_event.get('information', None) != None:
                    # current_app.logger.debug(json.dumps(redis_event.get('information'),cls=JSONEncoder))
                    # event_detail=CAPIFEventDetail().from_dict({redis_event.get('key'):redis_event.get('information')})
                    # current_app.logger.debug(json.dumps(event_detail,cls=JSONEncoder))
                    event_detail={redis_event.get('key'):redis_event.get('information')}
                
                data = EventNotification(sub["subscription_id"], events=redis_event.get('event'), event_detail=[event_detail])
                current_app.logger.debug(json.dumps(data,cls=JSONEncoder))
                
                # self.request_post(url, data)
                asyncio.run(self.send(url, json.dumps(data,cls=JSONEncoder)))

        except Exception as e:
            current_app.logger.error("An exception occurred ::" + str(e))
            return False

    def request_post(self, url, data):
        headers = {'content-type': 'application/json'}
        return requests.post(url, json={'text': str(data.to_str())}, headers=headers)
    
    async def send_request(self, url, data):
        async with aiohttp.ClientSession() as session:
            timeout = aiohttp.ClientTimeout(total=10)  # Establecer timeout a 10 segundos
            async with session.post(url, json=data, timeout=timeout) as response:
                return await response.text()
    
    async def send(self, url, data):
        try:
            response = await self.send_request(url, data)
            print(response)
        except asyncio.TimeoutError:
            print("Timeout: Request timeout")



