from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from service_apis.models.base_model import Model
from service_apis import util


class IpAddrInfo(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, ipv4_addr=None, ipv6_addr=None):  # noqa: E501
        """IpAddrInfo - a model defined in OpenAPI

        :param ipv4_addr: The ipv4_addr of this IpAddrInfo.  # noqa: E501
        :type ipv4_addr: str
        :param ipv6_addr: The ipv6_addr of this IpAddrInfo.  # noqa: E501
        :type ipv6_addr: str
        """
        self.openapi_types = {
            'ipv4_addr': str,
            'ipv6_addr': str
        }

        self.attribute_map = {
            'ipv4_addr': 'ipv4Addr',
            'ipv6_addr': 'ipv6Addr'
        }

        self._ipv4_addr = ipv4_addr
        self._ipv6_addr = ipv6_addr

    @classmethod
    def from_dict(cls, dikt) -> 'IpAddrInfo':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The IpAddrInfo of this IpAddrInfo.  # noqa: E501
        :rtype: IpAddrInfo
        """
        return util.deserialize_model(dikt, cls)

    @property
    def ipv4_addr(self) -> str:
        """Gets the ipv4_addr of this IpAddrInfo.

        string identifying a Ipv4 address formatted in the \"dotted decimal\" notation as defined in IETF RFC 1166.   # noqa: E501

        :return: The ipv4_addr of this IpAddrInfo.
        :rtype: str
        """
        return self._ipv4_addr

    @ipv4_addr.setter
    def ipv4_addr(self, ipv4_addr: str):
        """Sets the ipv4_addr of this IpAddrInfo.

        string identifying a Ipv4 address formatted in the \"dotted decimal\" notation as defined in IETF RFC 1166.   # noqa: E501

        :param ipv4_addr: The ipv4_addr of this IpAddrInfo.
        :type ipv4_addr: str
        """

        self._ipv4_addr = ipv4_addr

    @property
    def ipv6_addr(self) -> str:
        """Gets the ipv6_addr of this IpAddrInfo.

        string identifying a Ipv6 address formatted according to clause 4 in IETF RFC 5952. The mixed Ipv4 Ipv6 notation according to clause 5 of IETF RFC 5952 shall not be used.   # noqa: E501

        :return: The ipv6_addr of this IpAddrInfo.
        :rtype: str
        """
        return self._ipv6_addr

    @ipv6_addr.setter
    def ipv6_addr(self, ipv6_addr: str):
        """Sets the ipv6_addr of this IpAddrInfo.

        string identifying a Ipv6 address formatted according to clause 4 in IETF RFC 5952. The mixed Ipv4 Ipv6 notation according to clause 5 of IETF RFC 5952 shall not be used.   # noqa: E501

        :param ipv6_addr: The ipv6_addr of this IpAddrInfo.
        :type ipv6_addr: str
        """

        self._ipv6_addr = ipv6_addr
