from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from api_invoker_management.models.base_model import Model
from api_invoker_management.models.communication_type import CommunicationType
from api_invoker_management.models.operation import Operation
from api_invoker_management import util

from api_invoker_management.models.communication_type import CommunicationType  # noqa: E501
from api_invoker_management.models.operation import Operation  # noqa: E501

class CustomOperation(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, comm_type=None, cust_op_name=None, operations=None, description=None):  # noqa: E501
        """CustomOperation - a model defined in OpenAPI

        :param comm_type: The comm_type of this CustomOperation.  # noqa: E501
        :type comm_type: CommunicationType
        :param cust_op_name: The cust_op_name of this CustomOperation.  # noqa: E501
        :type cust_op_name: str
        :param operations: The operations of this CustomOperation.  # noqa: E501
        :type operations: List[Operation]
        :param description: The description of this CustomOperation.  # noqa: E501
        :type description: str
        """
        self.openapi_types = {
            'comm_type': CommunicationType,
            'cust_op_name': str,
            'operations': List[Operation],
            'description': str
        }

        self.attribute_map = {
            'comm_type': 'commType',
            'cust_op_name': 'custOpName',
            'operations': 'operations',
            'description': 'description'
        }

        self._comm_type = comm_type
        self._cust_op_name = cust_op_name
        self._operations = operations
        self._description = description

    @classmethod
    def from_dict(cls, dikt) -> 'CustomOperation':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The CustomOperation of this CustomOperation.  # noqa: E501
        :rtype: CustomOperation
        """
        return util.deserialize_model(dikt, cls)

    @property
    def comm_type(self) -> CommunicationType:
        """Gets the comm_type of this CustomOperation.


        :return: The comm_type of this CustomOperation.
        :rtype: CommunicationType
        """
        return self._comm_type

    @comm_type.setter
    def comm_type(self, comm_type: CommunicationType):
        """Sets the comm_type of this CustomOperation.


        :param comm_type: The comm_type of this CustomOperation.
        :type comm_type: CommunicationType
        """
        if comm_type is None:
            raise ValueError("Invalid value for `comm_type`, must not be `None`")  # noqa: E501

        self._comm_type = comm_type

    @property
    def cust_op_name(self) -> str:
        """Gets the cust_op_name of this CustomOperation.

        it is set as {custOpName} part of the URI structure for a custom operation without resource association as defined in clause 5.2.4 of 3GPP TS 29.122.   # noqa: E501

        :return: The cust_op_name of this CustomOperation.
        :rtype: str
        """
        return self._cust_op_name

    @cust_op_name.setter
    def cust_op_name(self, cust_op_name: str):
        """Sets the cust_op_name of this CustomOperation.

        it is set as {custOpName} part of the URI structure for a custom operation without resource association as defined in clause 5.2.4 of 3GPP TS 29.122.   # noqa: E501

        :param cust_op_name: The cust_op_name of this CustomOperation.
        :type cust_op_name: str
        """
        if cust_op_name is None:
            raise ValueError("Invalid value for `cust_op_name`, must not be `None`")  # noqa: E501

        self._cust_op_name = cust_op_name

    @property
    def operations(self) -> List[Operation]:
        """Gets the operations of this CustomOperation.

        Supported HTTP methods for the API resource. Only applicable when the protocol in AefProfile indicates HTTP.   # noqa: E501

        :return: The operations of this CustomOperation.
        :rtype: List[Operation]
        """
        return self._operations

    @operations.setter
    def operations(self, operations: List[Operation]):
        """Sets the operations of this CustomOperation.

        Supported HTTP methods for the API resource. Only applicable when the protocol in AefProfile indicates HTTP.   # noqa: E501

        :param operations: The operations of this CustomOperation.
        :type operations: List[Operation]
        """
        if operations is not None and len(operations) < 1:
            raise ValueError("Invalid value for `operations`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._operations = operations

    @property
    def description(self) -> str:
        """Gets the description of this CustomOperation.

        Text description of the custom operation  # noqa: E501

        :return: The description of this CustomOperation.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str):
        """Sets the description of this CustomOperation.

        Text description of the custom operation  # noqa: E501

        :param description: The description of this CustomOperation.
        :type description: str
        """

        self._description = description
