def create_service_api_description(api_name="service_1", aef_id="aef_id", supported_features="0", vendor_specific_service_api_description=None, vendor_specific_aef_profile=None):
    aef_ids = list()
    if isinstance(aef_id, list):
        aef_ids = aef_id
        print("aef_id parameter is a list")
    elif isinstance(aef_id, str):
        print("aef_id parameter is a string")
        aef_ids.append(aef_id)

    profiles = create_aef_profiles(aef_ids)

    body = {
        "apiName": api_name,
        "aefProfiles": profiles,
        "description": "ROBOT_TESTING",
        "shareableInfo": {
            "isShareable": True,
            "capifProvDoms": [
                "string"
            ]
        },
        "serviceAPICategory": "string",
        "apiSuppFeats": "fffff",
        "pubApiPath": {
            "ccfIds": [
                "string"
            ]
        },
        "ccfId": "string"
    }

    if vendor_specific_service_api_description is not None:
        if isinstance(vendor_specific_service_api_description, dict):
            for key, value in vendor_specific_service_api_description.items():
                body[key] = value
    if vendor_specific_aef_profile is not None:
        if isinstance(vendor_specific_aef_profile, dict):
            for key, value in vendor_specific_aef_profile.items():
                body["aefProfiles"][0][key] = value
    if supported_features is not None:
        body['supportedFeatures'] = supported_features

    return body


def create_aef_profiles(aef_ids):
    profiles = list()
    index=1
    for aef_id in aef_ids:
        profiles.append(create_aef_profile(aef_id,"resource_" + str(index)))
        index=index+1
    return profiles



def create_aef_profile(aef_id, resource_name):
    data = {
        "aefId": aef_id,
        "versions": [
            {
                "apiVersion": "v1",
                "expiry": "2021-11-30T10:32:02.004000+00:00",
                "resources": [
                    {
                        "resourceName": resource_name,
                        "commType": "REQUEST_RESPONSE",
                        "uri": "string",
                        "custOpName": "string",
                        "operations": [
                                    "GET"
                        ],
                        "description": "string"
                    }
                ],
            }
        ],
        "protocol": "HTTP_1_1",
        "dataFormat": "JSON",
        "securityMethods": ["PSK"],
        "interfaceDescriptions": [
                    {
                        "ipv4Addr": "string",
                        "port": 65535,
                        "securityMethods": ["PSK"]
                    }
        ]
    }
    return data
