from dis import dis
import requests
import json
import configparser
import redis
import os
import argparse
import re
from termcolor import colored

# Get environment variables


class InvokerToService():
    def __demo_to_aef(self, operation, demo_ip, demo_port, demo_url, jwt_token, name, log_level):

        #def register_netapp_to_nef(nef_ip, nef_port):
        access_token_url = "https://{}:{}/api/v1/login/access-token".format(demo_ip, demo_port)

        access_payload = {
        "username": "admin@my-email.com",
        "password": "pass"
        }

        response = requests.request('POST', access_token_url, data=access_payload, verify=False)
        parsed = json.loads(response.text)

        access_token = parsed['access_token']

        print(colored("Using AEF Service API","yellow"))
        url = "https://{}:{}{}".format(demo_ip, demo_port, demo_url)
        #url = "http://python_aef:8086/hello"


      
        json_file = open('capif_ops/config_files/service_request_body.json', 'rb')
        payload_dict = json.load(json_file)
        payload = json.dumps(payload_dict, indent=2)

        files = {}
        headers = {
            'Content-Type': 'application/json',
            'Authorization': 'Bearer '+ access_token + "," +jwt_token
        }

        if operation == "create":
            print(colored(f"Request Body: {payload}", "yellow"))
            try:
                if log_level == "debug":
                    print(colored("''''''''''REQUEST'''''''''''''''''","blue"))
                    print(colored(f"Request: to {url}","blue"))
                    print(colored(f"Request Headers: {headers}", "blue"))
                    print(colored(f"Request Body: {json.dumps(payload, indent=2)}", "blue"))
                    print(colored(f"''''''''''REQUEST'''''''''''''''''", "blue"))
                response = requests.request("POST", url, headers=headers, data=payload, files=files, verify=False)
                response.raise_for_status()
                response_payload = json.loads(response.text)

                if log_level == "debug":
                    print(colored("''''''''''RESPONSE'''''''''''''''''","green"))
                    print(colored(f"Response to: {response.url}","green"))
                    print(colored(f"Response Headers: {response.headers}","green"))
                    print(colored(f"Response: {response.json()}","green"))
                    print(colored(f"Response Status code: {response.status_code}","green"))
                    print(colored("Success to invoke service","green"))
                    print(colored(response_payload,"green"))
                    print(colored("''''''''''RESPONSE'''''''''''''''''","green"))

                link_created_resource = response_payload["link"]
                resource_id = link_created_resource.rsplit('/', 1)[-1]
                if resource_id:
                    with open('capif_ops/config_files/demo_values.json', 'r') as demo_file:
                        demo_values = json.load(demo_file)
                    demo_values["demo_resource_id"] = resource_id
                    with open('capif_ops/config_files/demo_values.json', 'w') as outfile:
                        json.dump(demo_values, outfile)

                return response_payload
            except requests.exceptions.HTTPError as err:
                print(err.response.text)
                message = json.loads(err.response.text)
                status = err.response.status_code
                raise Exception(message, status)
            
        elif operation == "delete":
            with open('capif_ops/config_files/demo_values.json', 'r') as demo_file:
                        demo_values = json.load(demo_file)
            resource_id = demo_values["demo_resource_id"]
            if resource_id == "":
                print("Not found resource to delete")
                return 

            url = url + "/" + resource_id
            try:
                if log_level == "debug":
                    print(colored("''''''''''REQUEST'''''''''''''''''","blue"))
                    print(colored(f"Request: to {url}","blue"))
                    print(colored(f"Request Headers: {headers}", "blue"))
                    print(colored(f"''''''''''REQUEST'''''''''''''''''", "blue"))
                response = requests.request("DELETE", url, headers=headers, verify=False)
                response.raise_for_status()
                response_payload = json.loads(response.text)

                if log_level == "debug":
                    print(colored("''''''''''RESPONSE'''''''''''''''''","green"))
                    print(colored(f"Response to: {response.url}","green"))
                    print(colored(f"Response Headers: {response.headers}","green"))
                    print(colored(f"Response: {response.json()}","green"))
                    print(colored(f"Response Status code: {response.status_code}","green"))
                    print(colored("Success to invoke service","green"))
                    print(colored(response_payload,"green"))
                    print(colored("''''''''''RESPONSE'''''''''''''''''","green"))

                demo_values["demo_resource_id"] = ""
                with open('capif_ops/config_files/demo_values.json', 'w') as outfile:
                    json.dump(demo_values, outfile)

                return response_payload
            except requests.exceptions.HTTPError as err:
                print(err.response.text)
                message = json.loads(err.response.text)
                status = err.response.status_code
                raise Exception(message, status)

        else:
            print("You must spicify if you want create or delete resource")


    def execute_invoker_to_service(self, input):

        # parser = argparse.ArgumentParser()
        # parser.add_argument('--name', metavar= "name", type=str, default="Evolve5G", help="Name to send to the aef service")
        # args = parser.parse_args()
        input_name = "prueba"
        operation = ""
        log_level = ""
        params = input.split()
        if len(params) > 0:
            operation = params[0]
            if len(params) > 1:
                log_level = params[1]

        with open('capif_ops/config_files/demo_values.json', 'r') as demo_file:
            demo_values = json.load(demo_file)

        try:
            if 'netapp_service_token' in demo_values:

                print(colored("Doing test","yellow"))
                jwt_token = demo_values['netapp_service_token']
                invokerID = demo_values['invokerID']
                demo_ip = demo_values['demo_ipv4_addr_0']
                #demo_port = demo_values['demo_port_0']
                demo_port = 4443
                demo_url = demo_values['demo_url_0']
                demo_url = re.sub(r'\{scsAsId\}', 'myNetapp', demo_url)

                result = self.__demo_to_aef(operation, demo_ip, demo_port, demo_url, jwt_token, input_name, log_level)
                print(colored(f"Response: {json.dumps(result, indent=2)}", "yellow"))
                print(colored("Success","yellow"))
        except Exception as e:
            status_code = e.args[0]
            if status_code == 401:
                print("API Invoker is not authorized")
            elif status_code == 403:
                print("API Invoker does not exist. API Invoker id not found")
            else:
                print(e)