#!/bin/bash

help() {
  echo "Usage: $0 <options>"
  echo "       -c : Show capif services"
  echo "       -v : Show vault service"
  echo "       -r : Show register service"
  echo "       -m : Show monitoring service"
  echo "       -a : Show all services"
  echo "       -f : Follow log output"
  echo "       -h : Show this help"
  exit 1
}

if [[ $# -lt 1 ]]
then
  echo "You must specify an option before run script."
  help
fi

FILES=()
echo "${FILES[@]}"
FOLLOW=""

# Read params
while getopts "cvrahmf" opt; do
  case $opt in
    c)
      echo "Show Capif services"
      FILES+=("-f docker-compose-capif.yml")
      ;;
    v)
      echo "Show vault service"
      FILES+=("-f docker-compose-vault.yml")
      ;;
    r)
      echo "Show register service"
      FILES+=("-f docker-compose-register.yml")
      ;;
    m)
      echo "Show monitoring service"
      FILES+=("-f ../monitoring/docker-compose.yml")
      ;;
    a)
      echo "Show all services"
      FILES=("-f docker-compose-capif.yml" -f "docker-compose-vault.yml" -f "docker-compose-register.yml" -f "../monitoring/docker-compose.yml")
      ;;
    f)
      echo "Setup follow logs"
      FOLLOW="-f"
      ;;
    h)
      help
      ;;
    ?)
      echo "Not valid option: -$OPTARG" >&2
      help
      exit 1
      ;;
    :)
      echo "The -$OPTARG option requires an argument." >&2
      help
      exit 1
      ;;
    \*)
      echo "Not valid parameter $opt"
      help
      exit 1
      ;;
  esac
done

if [[ $1 =~ ^- ]]
then
  echo "${FILES[@]}"
else
  help
fi

docker compose ${FILES[@]} logs ${FOLLOW}

