#!/bin/bash
CERTS_FOLDER="/usr/src/app/register_service/certs"
cd $CERTS_FOLDER

openssl req -x509 \
            -sha256 -days 356 \
            -nodes \
            -newkey rsa:2048 \
            -subj "/CN=register/C=ES/L=Madrid" \
            -keyout /usr/src/app/register_service/certs/registerCA.key -out /usr/src/app/register_service/certs/registerCA.crt


openssl genrsa -out /usr/src/app/register_service/certs/register_key.key 2048

COUNTRY="ES"                # 2 letter country-code
STATE="Madrid"            # state or province name
LOCALITY="Madrid"        # Locality Name (e.g. city)
ORGNAME="Telefonica I+D" # Organization Name (eg, company)
ORGUNIT="Innovation"                  # Organizational Unit Name (eg. section)
COMMONNAME="register"
EMAIL="inno@tid.es"    # certificate's email address
# optional extra details
CHALLENGE=""                # challenge password
COMPANY=""                  # company name

# DAYS="-days 365"

# create the certificate request
cat <<__EOF__ | openssl req -new $DAYS -key /usr/src/app/register_service/certs/register_key.key -out /usr/src/app/register_service/certs/register.csr
$COUNTRY
$STATE
$LOCALITY
$ORGNAME
$ORGUNIT
$COMMONNAME
$EMAIL
$CHALLENGE
$COMPANY
__EOF__

openssl x509 -req -in /usr/src/app/register_service/certs/register.csr -CA /usr/src/app/register_service/certs/registerCA.crt -CAkey /usr/src/app/register_service/certs/registerCA.key  -CAcreateserial -out /usr/src/app/register_service/certs/register_cert.crt -days 365 -sha256

cd /usr/src/app/
python3 -m register_service