from ..models.problem_details import ProblemDetails
from ..encoder import CustomJSONEncoder
from flask import Response
from ..util import dict_to_camel_case, clean_empty, serialize_clean_camel_case
import json

mimetype = "application/json"


def make_response(object, status):
    res = Response(json.dumps(object, cls=CustomJSONEncoder), status=status, mimetype=mimetype)

    return res


def internal_server_error(detail, cause):
    prob = ProblemDetails(title="Internal Server Error", status=500, detail=detail, cause=cause)
    prob = serialize_clean_camel_case(prob)

    return Response(json.dumps(prob, cls=CustomJSONEncoder), status=500, mimetype=mimetype)


def forbidden_error(detail, cause):
    prob = ProblemDetails(title="Forbidden", status=403, detail=detail, cause=cause)
    prob = serialize_clean_camel_case(prob)

    return Response(json.dumps(prob, cls=CustomJSONEncoder), status=403, mimetype=mimetype)


def bad_request_error(detail, cause, invalid_params):
    prob = ProblemDetails(title="Bad Request", status=400, detail=detail, cause=cause, invalid_params=invalid_params)
    prob = serialize_clean_camel_case(prob)

    return Response(json.dumps(prob, cls=CustomJSONEncoder), status=400, mimetype=cause)


def not_found_error(detail, cause):
    prob = ProblemDetails(title="Not Found", status=404, detail=detail, cause=cause)
    prob = serialize_clean_camel_case(prob)

    return Response(json.dumps(prob, cls=CustomJSONEncoder), status=404, mimetype=mimetype)