#import concurrent
import requests
from .internal_event_ops import InternalEventOperations
from ..models.event_notification import EventNotification
from ..models.access_control_policy_list_ext import AccessControlPolicyListExt
from ..models.capif_event_detail import CAPIFEventDetail
from ..encoder import JSONEncoder
import sys
import json
from flask import current_app
import asyncio
import aiohttp

class Notifications():

    def __init__(self):
        self.events_ops = InternalEventOperations()

    def send_notifications(self, redis_event):
        try:
            if redis_event.get('event', None) == None:
                raise("Event value is not present on received event from REDIS")
            
            current_app.logger.info("Received event " + redis_event.get('event') + ", sending notifications")
            subscriptions = self.events_ops.get_event_subscriptions(redis_event.get('event'))
            current_app.logger.info(subscriptions)

            for sub in subscriptions:
                url = sub["notification_destination"]
                current_app.logger.debug(url)
                event_detail=None
                if redis_event.get('key', None) != None and redis_event.get('information', None) != None:
                    event_detail={redis_event.get('key'):redis_event.get('information')}
                current_app.logger.debug(event_detail)
                data = EventNotification(sub["subscription_id"], events=redis_event.get('event'), event_detail=event_detail)
                current_app.logger.debug(json.dumps(data,cls=JSONEncoder))

                asyncio.run(self.send(url, json.loads(json.dumps(data,cls=JSONEncoder))))

        except Exception as e:
            current_app.logger.error("An exception occurred ::" + str(e))
            return False

    def request_post(self, url, data):
        headers = {'content-type': 'application/json'}
        return requests.post(url, json={'text': str(data.to_str())}, headers=headers)
    
    async def send_request(self, url, data):
        async with aiohttp.ClientSession() as session:
            timeout = aiohttp.ClientTimeout(total=10)  # Establecer timeout a 10 segundos
            headers = {'content-type': 'application/json'}
            async with session.post(url, json=data, timeout=timeout, headers=headers) as response:
                return await response.text()
    
    async def send(self, url, data):
        try:
            response = await self.send_request(url, data)
            current_app.logger.debug(response)
        except asyncio.TimeoutError:
            current_app.logger.error("Timeout: Request timeout")
        except Exception as e:
            current_app.logger.error("An exception occurred sending notification::" + str(e))
            return False
