from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from api_invoker_management.models.base_model import Model
from api_invoker_management.models.api_list import APIList
from api_invoker_management.models.onboarding_information import OnboardingInformation
from api_invoker_management import util

from api_invoker_management.models.api_list import APIList  # noqa: E501
from api_invoker_management.models.onboarding_information import OnboardingInformation  # noqa: E501

class APIInvokerEnrolmentDetailsPatch(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, onboarding_information=None, notification_destination=None, api_list=None, api_invoker_information=None, exp_time=None):  # noqa: E501
        """APIInvokerEnrolmentDetailsPatch - a model defined in OpenAPI

        :param onboarding_information: The onboarding_information of this APIInvokerEnrolmentDetailsPatch.  # noqa: E501
        :type onboarding_information: OnboardingInformation
        :param notification_destination: The notification_destination of this APIInvokerEnrolmentDetailsPatch.  # noqa: E501
        :type notification_destination: str
        :param api_list: The api_list of this APIInvokerEnrolmentDetailsPatch.  # noqa: E501
        :type api_list: APIList
        :param api_invoker_information: The api_invoker_information of this APIInvokerEnrolmentDetailsPatch.  # noqa: E501
        :type api_invoker_information: str
        :param exp_time: The exp_time of this APIInvokerEnrolmentDetailsPatch.  # noqa: E501
        :type exp_time: datetime
        """
        self.openapi_types = {
            'onboarding_information': OnboardingInformation,
            'notification_destination': str,
            'api_list': APIList,
            'api_invoker_information': str,
            'exp_time': datetime
        }

        self.attribute_map = {
            'onboarding_information': 'onboardingInformation',
            'notification_destination': 'notificationDestination',
            'api_list': 'apiList',
            'api_invoker_information': 'apiInvokerInformation',
            'exp_time': 'expTime'
        }

        self._onboarding_information = onboarding_information
        self._notification_destination = notification_destination
        self._api_list = api_list
        self._api_invoker_information = api_invoker_information
        self._exp_time = exp_time

    @classmethod
    def from_dict(cls, dikt) -> 'APIInvokerEnrolmentDetailsPatch':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The APIInvokerEnrolmentDetailsPatch of this APIInvokerEnrolmentDetailsPatch.  # noqa: E501
        :rtype: APIInvokerEnrolmentDetailsPatch
        """
        return util.deserialize_model(dikt, cls)

    @property
    def onboarding_information(self) -> OnboardingInformation:
        """Gets the onboarding_information of this APIInvokerEnrolmentDetailsPatch.


        :return: The onboarding_information of this APIInvokerEnrolmentDetailsPatch.
        :rtype: OnboardingInformation
        """
        return self._onboarding_information

    @onboarding_information.setter
    def onboarding_information(self, onboarding_information: OnboardingInformation):
        """Sets the onboarding_information of this APIInvokerEnrolmentDetailsPatch.


        :param onboarding_information: The onboarding_information of this APIInvokerEnrolmentDetailsPatch.
        :type onboarding_information: OnboardingInformation
        """

        self._onboarding_information = onboarding_information

    @property
    def notification_destination(self) -> str:
        """Gets the notification_destination of this APIInvokerEnrolmentDetailsPatch.

        string providing an URI formatted according to IETF RFC 3986.  # noqa: E501

        :return: The notification_destination of this APIInvokerEnrolmentDetailsPatch.
        :rtype: str
        """
        return self._notification_destination

    @notification_destination.setter
    def notification_destination(self, notification_destination: str):
        """Sets the notification_destination of this APIInvokerEnrolmentDetailsPatch.

        string providing an URI formatted according to IETF RFC 3986.  # noqa: E501

        :param notification_destination: The notification_destination of this APIInvokerEnrolmentDetailsPatch.
        :type notification_destination: str
        """

        self._notification_destination = notification_destination

    @property
    def api_list(self) -> APIList:
        """Gets the api_list of this APIInvokerEnrolmentDetailsPatch.


        :return: The api_list of this APIInvokerEnrolmentDetailsPatch.
        :rtype: APIList
        """
        return self._api_list

    @api_list.setter
    def api_list(self, api_list: APIList):
        """Sets the api_list of this APIInvokerEnrolmentDetailsPatch.


        :param api_list: The api_list of this APIInvokerEnrolmentDetailsPatch.
        :type api_list: APIList
        """

        self._api_list = api_list

    @property
    def api_invoker_information(self) -> str:
        """Gets the api_invoker_information of this APIInvokerEnrolmentDetailsPatch.

        Generic information related to the API invoker such as details of the device or the application.   # noqa: E501

        :return: The api_invoker_information of this APIInvokerEnrolmentDetailsPatch.
        :rtype: str
        """
        return self._api_invoker_information

    @api_invoker_information.setter
    def api_invoker_information(self, api_invoker_information: str):
        """Sets the api_invoker_information of this APIInvokerEnrolmentDetailsPatch.

        Generic information related to the API invoker such as details of the device or the application.   # noqa: E501

        :param api_invoker_information: The api_invoker_information of this APIInvokerEnrolmentDetailsPatch.
        :type api_invoker_information: str
        """

        self._api_invoker_information = api_invoker_information

    @property
    def exp_time(self) -> datetime:
        """Gets the exp_time of this APIInvokerEnrolmentDetailsPatch.

        string with format \"date-time\" as defined in OpenAPI with \"nullable=true\" property.   # noqa: E501

        :return: The exp_time of this APIInvokerEnrolmentDetailsPatch.
        :rtype: datetime
        """
        return self._exp_time

    @exp_time.setter
    def exp_time(self, exp_time: datetime):
        """Sets the exp_time of this APIInvokerEnrolmentDetailsPatch.

        string with format \"date-time\" as defined in OpenAPI with \"nullable=true\" property.   # noqa: E501

        :param exp_time: The exp_time of this APIInvokerEnrolmentDetailsPatch.
        :type exp_time: datetime
        """

        self._exp_time = exp_time
