from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from published_apis.models.base_model import Model
from published_apis.models.aef_profile import AefProfile
from published_apis.models.api_status import ApiStatus
from published_apis.models.published_api_path import PublishedApiPath
from published_apis.models.shareable_information import ShareableInformation
import re
from published_apis import util

from published_apis.models.aef_profile import AefProfile  # noqa: E501
from published_apis.models.api_status import ApiStatus  # noqa: E501
from published_apis.models.published_api_path import PublishedApiPath  # noqa: E501
from published_apis.models.shareable_information import ShareableInformation  # noqa: E501
import re  # noqa: E501

class ServiceAPIDescriptionPatch(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, api_status=None, aef_profiles=None, description=None, shareable_info=None, service_api_category=None, api_supp_feats=None, pub_api_path=None, ccf_id=None):  # noqa: E501
        """ServiceAPIDescriptionPatch - a model defined in OpenAPI

        :param api_status: The api_status of this ServiceAPIDescriptionPatch.  # noqa: E501
        :type api_status: ApiStatus
        :param aef_profiles: The aef_profiles of this ServiceAPIDescriptionPatch.  # noqa: E501
        :type aef_profiles: List[AefProfile]
        :param description: The description of this ServiceAPIDescriptionPatch.  # noqa: E501
        :type description: str
        :param shareable_info: The shareable_info of this ServiceAPIDescriptionPatch.  # noqa: E501
        :type shareable_info: ShareableInformation
        :param service_api_category: The service_api_category of this ServiceAPIDescriptionPatch.  # noqa: E501
        :type service_api_category: str
        :param api_supp_feats: The api_supp_feats of this ServiceAPIDescriptionPatch.  # noqa: E501
        :type api_supp_feats: str
        :param pub_api_path: The pub_api_path of this ServiceAPIDescriptionPatch.  # noqa: E501
        :type pub_api_path: PublishedApiPath
        :param ccf_id: The ccf_id of this ServiceAPIDescriptionPatch.  # noqa: E501
        :type ccf_id: str
        """
        self.openapi_types = {
            'api_status': ApiStatus,
            'aef_profiles': List[AefProfile],
            'description': str,
            'shareable_info': ShareableInformation,
            'service_api_category': str,
            'api_supp_feats': str,
            'pub_api_path': PublishedApiPath,
            'ccf_id': str
        }

        self.attribute_map = {
            'api_status': 'apiStatus',
            'aef_profiles': 'aefProfiles',
            'description': 'description',
            'shareable_info': 'shareableInfo',
            'service_api_category': 'serviceAPICategory',
            'api_supp_feats': 'apiSuppFeats',
            'pub_api_path': 'pubApiPath',
            'ccf_id': 'ccfId'
        }

        self._api_status = api_status
        self._aef_profiles = aef_profiles
        self._description = description
        self._shareable_info = shareable_info
        self._service_api_category = service_api_category
        self._api_supp_feats = api_supp_feats
        self._pub_api_path = pub_api_path
        self._ccf_id = ccf_id

    @classmethod
    def from_dict(cls, dikt) -> 'ServiceAPIDescriptionPatch':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ServiceAPIDescriptionPatch of this ServiceAPIDescriptionPatch.  # noqa: E501
        :rtype: ServiceAPIDescriptionPatch
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api_status(self) -> ApiStatus:
        """Gets the api_status of this ServiceAPIDescriptionPatch.


        :return: The api_status of this ServiceAPIDescriptionPatch.
        :rtype: ApiStatus
        """
        return self._api_status

    @api_status.setter
    def api_status(self, api_status: ApiStatus):
        """Sets the api_status of this ServiceAPIDescriptionPatch.


        :param api_status: The api_status of this ServiceAPIDescriptionPatch.
        :type api_status: ApiStatus
        """

        self._api_status = api_status

    @property
    def aef_profiles(self) -> List[AefProfile]:
        """Gets the aef_profiles of this ServiceAPIDescriptionPatch.

        AEF profile information, which includes the exposed API details.  # noqa: E501

        :return: The aef_profiles of this ServiceAPIDescriptionPatch.
        :rtype: List[AefProfile]
        """
        return self._aef_profiles

    @aef_profiles.setter
    def aef_profiles(self, aef_profiles: List[AefProfile]):
        """Sets the aef_profiles of this ServiceAPIDescriptionPatch.

        AEF profile information, which includes the exposed API details.  # noqa: E501

        :param aef_profiles: The aef_profiles of this ServiceAPIDescriptionPatch.
        :type aef_profiles: List[AefProfile]
        """
        if aef_profiles is not None and len(aef_profiles) < 1:
            raise ValueError("Invalid value for `aef_profiles`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._aef_profiles = aef_profiles

    @property
    def description(self) -> str:
        """Gets the description of this ServiceAPIDescriptionPatch.

        Text description of the API  # noqa: E501

        :return: The description of this ServiceAPIDescriptionPatch.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str):
        """Sets the description of this ServiceAPIDescriptionPatch.

        Text description of the API  # noqa: E501

        :param description: The description of this ServiceAPIDescriptionPatch.
        :type description: str
        """

        self._description = description

    @property
    def shareable_info(self) -> ShareableInformation:
        """Gets the shareable_info of this ServiceAPIDescriptionPatch.


        :return: The shareable_info of this ServiceAPIDescriptionPatch.
        :rtype: ShareableInformation
        """
        return self._shareable_info

    @shareable_info.setter
    def shareable_info(self, shareable_info: ShareableInformation):
        """Sets the shareable_info of this ServiceAPIDescriptionPatch.


        :param shareable_info: The shareable_info of this ServiceAPIDescriptionPatch.
        :type shareable_info: ShareableInformation
        """

        self._shareable_info = shareable_info

    @property
    def service_api_category(self) -> str:
        """Gets the service_api_category of this ServiceAPIDescriptionPatch.

        The service API category to which the service API belongs to.  # noqa: E501

        :return: The service_api_category of this ServiceAPIDescriptionPatch.
        :rtype: str
        """
        return self._service_api_category

    @service_api_category.setter
    def service_api_category(self, service_api_category: str):
        """Sets the service_api_category of this ServiceAPIDescriptionPatch.

        The service API category to which the service API belongs to.  # noqa: E501

        :param service_api_category: The service_api_category of this ServiceAPIDescriptionPatch.
        :type service_api_category: str
        """

        self._service_api_category = service_api_category

    @property
    def api_supp_feats(self) -> str:
        """Gets the api_supp_feats of this ServiceAPIDescriptionPatch.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :return: The api_supp_feats of this ServiceAPIDescriptionPatch.
        :rtype: str
        """
        return self._api_supp_feats

    @api_supp_feats.setter
    def api_supp_feats(self, api_supp_feats: str):
        """Sets the api_supp_feats of this ServiceAPIDescriptionPatch.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :param api_supp_feats: The api_supp_feats of this ServiceAPIDescriptionPatch.
        :type api_supp_feats: str
        """
        if api_supp_feats is not None and not re.search(r'^[A-Fa-f0-9]*$', api_supp_feats):  # noqa: E501
            raise ValueError(r"Invalid value for `api_supp_feats`, must be a follow pattern or equal to `/^[A-Fa-f0-9]*$/`")  # noqa: E501

        self._api_supp_feats = api_supp_feats

    @property
    def pub_api_path(self) -> PublishedApiPath:
        """Gets the pub_api_path of this ServiceAPIDescriptionPatch.


        :return: The pub_api_path of this ServiceAPIDescriptionPatch.
        :rtype: PublishedApiPath
        """
        return self._pub_api_path

    @pub_api_path.setter
    def pub_api_path(self, pub_api_path: PublishedApiPath):
        """Sets the pub_api_path of this ServiceAPIDescriptionPatch.


        :param pub_api_path: The pub_api_path of this ServiceAPIDescriptionPatch.
        :type pub_api_path: PublishedApiPath
        """

        self._pub_api_path = pub_api_path

    @property
    def ccf_id(self) -> str:
        """Gets the ccf_id of this ServiceAPIDescriptionPatch.

        CAPIF core function identifier.  # noqa: E501

        :return: The ccf_id of this ServiceAPIDescriptionPatch.
        :rtype: str
        """
        return self._ccf_id

    @ccf_id.setter
    def ccf_id(self, ccf_id: str):
        """Sets the ccf_id of this ServiceAPIDescriptionPatch.

        CAPIF core function identifier.  # noqa: E501

        :param ccf_id: The ccf_id of this ServiceAPIDescriptionPatch.
        :type ccf_id: str
        """

        self._ccf_id = ccf_id
