from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from published_apis.models.base_model import Model
from published_apis.models.aef_location import AefLocation
from published_apis.models.data_format import DataFormat
from published_apis.models.interface_description import InterfaceDescription
from published_apis.models.ip_addr_range import IpAddrRange
from published_apis.models.o_auth_grant_type import OAuthGrantType
from published_apis.models.protocol import Protocol
from published_apis.models.security_method import SecurityMethod
from published_apis.models.service_kpis import ServiceKpis
from published_apis.models.version import Version
from published_apis import util

from published_apis.models.aef_location import AefLocation  # noqa: E501
from published_apis.models.data_format import DataFormat  # noqa: E501
from published_apis.models.interface_description import InterfaceDescription  # noqa: E501
from published_apis.models.ip_addr_range import IpAddrRange  # noqa: E501
from published_apis.models.o_auth_grant_type import OAuthGrantType  # noqa: E501
from published_apis.models.protocol import Protocol  # noqa: E501
from published_apis.models.security_method import SecurityMethod  # noqa: E501
from published_apis.models.service_kpis import ServiceKpis  # noqa: E501
from published_apis.models.version import Version  # noqa: E501

class AefProfile(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, aef_id=None, versions=None, protocol=None, data_format=None, security_methods=None, grant_types=None, domain_name=None, interface_descriptions=None, aef_location=None, service_kpis=None, ue_ip_range=None):  # noqa: E501
        """AefProfile - a model defined in OpenAPI

        :param aef_id: The aef_id of this AefProfile.  # noqa: E501
        :type aef_id: str
        :param versions: The versions of this AefProfile.  # noqa: E501
        :type versions: List[Version]
        :param protocol: The protocol of this AefProfile.  # noqa: E501
        :type protocol: Protocol
        :param data_format: The data_format of this AefProfile.  # noqa: E501
        :type data_format: DataFormat
        :param security_methods: The security_methods of this AefProfile.  # noqa: E501
        :type security_methods: List[SecurityMethod]
        :param grant_types: The grant_types of this AefProfile.  # noqa: E501
        :type grant_types: List[OAuthGrantType]
        :param domain_name: The domain_name of this AefProfile.  # noqa: E501
        :type domain_name: str
        :param interface_descriptions: The interface_descriptions of this AefProfile.  # noqa: E501
        :type interface_descriptions: List[InterfaceDescription]
        :param aef_location: The aef_location of this AefProfile.  # noqa: E501
        :type aef_location: AefLocation
        :param service_kpis: The service_kpis of this AefProfile.  # noqa: E501
        :type service_kpis: ServiceKpis
        :param ue_ip_range: The ue_ip_range of this AefProfile.  # noqa: E501
        :type ue_ip_range: IpAddrRange
        """
        self.openapi_types = {
            'aef_id': str,
            'versions': List[Version],
            'protocol': Protocol,
            'data_format': DataFormat,
            'security_methods': List[SecurityMethod],
            'grant_types': List[OAuthGrantType],
            'domain_name': str,
            'interface_descriptions': List[InterfaceDescription],
            'aef_location': AefLocation,
            'service_kpis': ServiceKpis,
            'ue_ip_range': IpAddrRange
        }

        self.attribute_map = {
            'aef_id': 'aefId',
            'versions': 'versions',
            'protocol': 'protocol',
            'data_format': 'dataFormat',
            'security_methods': 'securityMethods',
            'grant_types': 'grantTypes',
            'domain_name': 'domainName',
            'interface_descriptions': 'interfaceDescriptions',
            'aef_location': 'aefLocation',
            'service_kpis': 'serviceKpis',
            'ue_ip_range': 'ueIpRange'
        }

        self._aef_id = aef_id
        self._versions = versions
        self._protocol = protocol
        self._data_format = data_format
        self._security_methods = security_methods
        self._grant_types = grant_types
        self._domain_name = domain_name
        self._interface_descriptions = interface_descriptions
        self._aef_location = aef_location
        self._service_kpis = service_kpis
        self._ue_ip_range = ue_ip_range

    @classmethod
    def from_dict(cls, dikt) -> 'AefProfile':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The AefProfile of this AefProfile.  # noqa: E501
        :rtype: AefProfile
        """
        return util.deserialize_model(dikt, cls)

    @property
    def aef_id(self) -> str:
        """Gets the aef_id of this AefProfile.

        Identifier of the API exposing function  # noqa: E501

        :return: The aef_id of this AefProfile.
        :rtype: str
        """
        return self._aef_id

    @aef_id.setter
    def aef_id(self, aef_id: str):
        """Sets the aef_id of this AefProfile.

        Identifier of the API exposing function  # noqa: E501

        :param aef_id: The aef_id of this AefProfile.
        :type aef_id: str
        """
        if aef_id is None:
            raise ValueError("Invalid value for `aef_id`, must not be `None`")  # noqa: E501

        self._aef_id = aef_id

    @property
    def versions(self) -> List[Version]:
        """Gets the versions of this AefProfile.

        API version  # noqa: E501

        :return: The versions of this AefProfile.
        :rtype: List[Version]
        """
        return self._versions

    @versions.setter
    def versions(self, versions: List[Version]):
        """Sets the versions of this AefProfile.

        API version  # noqa: E501

        :param versions: The versions of this AefProfile.
        :type versions: List[Version]
        """
        if versions is None:
            raise ValueError("Invalid value for `versions`, must not be `None`")  # noqa: E501
        if versions is not None and len(versions) < 1:
            raise ValueError("Invalid value for `versions`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._versions = versions

    @property
    def protocol(self) -> Protocol:
        """Gets the protocol of this AefProfile.


        :return: The protocol of this AefProfile.
        :rtype: Protocol
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol: Protocol):
        """Sets the protocol of this AefProfile.


        :param protocol: The protocol of this AefProfile.
        :type protocol: Protocol
        """

        self._protocol = protocol

    @property
    def data_format(self) -> DataFormat:
        """Gets the data_format of this AefProfile.


        :return: The data_format of this AefProfile.
        :rtype: DataFormat
        """
        return self._data_format

    @data_format.setter
    def data_format(self, data_format: DataFormat):
        """Sets the data_format of this AefProfile.


        :param data_format: The data_format of this AefProfile.
        :type data_format: DataFormat
        """

        self._data_format = data_format

    @property
    def security_methods(self) -> List[SecurityMethod]:
        """Gets the security_methods of this AefProfile.

        Security methods supported by the AEF  # noqa: E501

        :return: The security_methods of this AefProfile.
        :rtype: List[SecurityMethod]
        """
        return self._security_methods

    @security_methods.setter
    def security_methods(self, security_methods: List[SecurityMethod]):
        """Sets the security_methods of this AefProfile.

        Security methods supported by the AEF  # noqa: E501

        :param security_methods: The security_methods of this AefProfile.
        :type security_methods: List[SecurityMethod]
        """
        if security_methods is not None and len(security_methods) < 1:
            raise ValueError("Invalid value for `security_methods`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._security_methods = security_methods

    @property
    def grant_types(self) -> List[OAuthGrantType]:
        """Gets the grant_types of this AefProfile.


        :return: The grant_types of this AefProfile.
        :rtype: List[OAuthGrantType]
        """
        return self._grant_types

    @grant_types.setter
    def grant_types(self, grant_types: List[OAuthGrantType]):
        """Sets the grant_types of this AefProfile.


        :param grant_types: The grant_types of this AefProfile.
        :type grant_types: List[OAuthGrantType]
        """
        if grant_types is not None and len(grant_types) < 1:
            raise ValueError("Invalid value for `grant_types`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._grant_types = grant_types

    @property
    def domain_name(self) -> str:
        """Gets the domain_name of this AefProfile.

        Domain to which API belongs to  # noqa: E501

        :return: The domain_name of this AefProfile.
        :rtype: str
        """
        return self._domain_name

    @domain_name.setter
    def domain_name(self, domain_name: str):
        """Sets the domain_name of this AefProfile.

        Domain to which API belongs to  # noqa: E501

        :param domain_name: The domain_name of this AefProfile.
        :type domain_name: str
        """

        self._domain_name = domain_name

    @property
    def interface_descriptions(self) -> List[InterfaceDescription]:
        """Gets the interface_descriptions of this AefProfile.

        Interface details  # noqa: E501

        :return: The interface_descriptions of this AefProfile.
        :rtype: List[InterfaceDescription]
        """
        return self._interface_descriptions

    @interface_descriptions.setter
    def interface_descriptions(self, interface_descriptions: List[InterfaceDescription]):
        """Sets the interface_descriptions of this AefProfile.

        Interface details  # noqa: E501

        :param interface_descriptions: The interface_descriptions of this AefProfile.
        :type interface_descriptions: List[InterfaceDescription]
        """
        if interface_descriptions is not None and len(interface_descriptions) < 1:
            raise ValueError("Invalid value for `interface_descriptions`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._interface_descriptions = interface_descriptions

    @property
    def aef_location(self) -> AefLocation:
        """Gets the aef_location of this AefProfile.


        :return: The aef_location of this AefProfile.
        :rtype: AefLocation
        """
        return self._aef_location

    @aef_location.setter
    def aef_location(self, aef_location: AefLocation):
        """Sets the aef_location of this AefProfile.


        :param aef_location: The aef_location of this AefProfile.
        :type aef_location: AefLocation
        """

        self._aef_location = aef_location

    @property
    def service_kpis(self) -> ServiceKpis:
        """Gets the service_kpis of this AefProfile.


        :return: The service_kpis of this AefProfile.
        :rtype: ServiceKpis
        """
        return self._service_kpis

    @service_kpis.setter
    def service_kpis(self, service_kpis: ServiceKpis):
        """Sets the service_kpis of this AefProfile.


        :param service_kpis: The service_kpis of this AefProfile.
        :type service_kpis: ServiceKpis
        """

        self._service_kpis = service_kpis

    @property
    def ue_ip_range(self) -> IpAddrRange:
        """Gets the ue_ip_range of this AefProfile.


        :return: The ue_ip_range of this AefProfile.
        :rtype: IpAddrRange
        """
        return self._ue_ip_range

    @ue_ip_range.setter
    def ue_ip_range(self, ue_ip_range: IpAddrRange):
        """Sets the ue_ip_range of this AefProfile.


        :param ue_ip_range: The ue_ip_range of this AefProfile.
        :type ue_ip_range: IpAddrRange
        """

        self._ue_ip_range = ue_ip_range
