from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from capif_events.models.base_model import Model
from capif_events.models.o_auth_grant_type import OAuthGrantType
from capif_events.models.security_method import SecurityMethod
import re
from capif_events import util

from capif_events.models.o_auth_grant_type import OAuthGrantType  # noqa: E501
from capif_events.models.security_method import SecurityMethod  # noqa: E501
import re  # noqa: E501

class InterfaceDescription(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, ipv4_addr=None, ipv6_addr=None, fqdn=None, port=None, api_prefix=None, security_methods=None, grant_types=None):  # noqa: E501
        """InterfaceDescription - a model defined in OpenAPI

        :param ipv4_addr: The ipv4_addr of this InterfaceDescription.  # noqa: E501
        :type ipv4_addr: str
        :param ipv6_addr: The ipv6_addr of this InterfaceDescription.  # noqa: E501
        :type ipv6_addr: str
        :param fqdn: The fqdn of this InterfaceDescription.  # noqa: E501
        :type fqdn: str
        :param port: The port of this InterfaceDescription.  # noqa: E501
        :type port: int
        :param api_prefix: The api_prefix of this InterfaceDescription.  # noqa: E501
        :type api_prefix: str
        :param security_methods: The security_methods of this InterfaceDescription.  # noqa: E501
        :type security_methods: List[SecurityMethod]
        :param grant_types: The grant_types of this InterfaceDescription.  # noqa: E501
        :type grant_types: List[OAuthGrantType]
        """
        self.openapi_types = {
            'ipv4_addr': str,
            'ipv6_addr': str,
            'fqdn': str,
            'port': int,
            'api_prefix': str,
            'security_methods': List[SecurityMethod],
            'grant_types': List[OAuthGrantType]
        }

        self.attribute_map = {
            'ipv4_addr': 'ipv4Addr',
            'ipv6_addr': 'ipv6Addr',
            'fqdn': 'fqdn',
            'port': 'port',
            'api_prefix': 'apiPrefix',
            'security_methods': 'securityMethods',
            'grant_types': 'grantTypes'
        }

        self._ipv4_addr = ipv4_addr
        self._ipv6_addr = ipv6_addr
        self._fqdn = fqdn
        self._port = port
        self._api_prefix = api_prefix
        self._security_methods = security_methods
        self._grant_types = grant_types

    @classmethod
    def from_dict(cls, dikt) -> 'InterfaceDescription':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The InterfaceDescription of this InterfaceDescription.  # noqa: E501
        :rtype: InterfaceDescription
        """
        return util.deserialize_model(dikt, cls)

    @property
    def ipv4_addr(self) -> str:
        """Gets the ipv4_addr of this InterfaceDescription.

        string identifying a Ipv4 address formatted in the \"dotted decimal\" notation as defined in IETF RFC 1166.   # noqa: E501

        :return: The ipv4_addr of this InterfaceDescription.
        :rtype: str
        """
        return self._ipv4_addr

    @ipv4_addr.setter
    def ipv4_addr(self, ipv4_addr: str):
        """Sets the ipv4_addr of this InterfaceDescription.

        string identifying a Ipv4 address formatted in the \"dotted decimal\" notation as defined in IETF RFC 1166.   # noqa: E501

        :param ipv4_addr: The ipv4_addr of this InterfaceDescription.
        :type ipv4_addr: str
        """

        self._ipv4_addr = ipv4_addr

    @property
    def ipv6_addr(self) -> str:
        """Gets the ipv6_addr of this InterfaceDescription.

        string identifying a Ipv6 address formatted according to clause 4 in IETF RFC 5952. The mixed Ipv4 Ipv6 notation according to clause 5 of IETF RFC 5952 shall not be used.   # noqa: E501

        :return: The ipv6_addr of this InterfaceDescription.
        :rtype: str
        """
        return self._ipv6_addr

    @ipv6_addr.setter
    def ipv6_addr(self, ipv6_addr: str):
        """Sets the ipv6_addr of this InterfaceDescription.

        string identifying a Ipv6 address formatted according to clause 4 in IETF RFC 5952. The mixed Ipv4 Ipv6 notation according to clause 5 of IETF RFC 5952 shall not be used.   # noqa: E501

        :param ipv6_addr: The ipv6_addr of this InterfaceDescription.
        :type ipv6_addr: str
        """

        self._ipv6_addr = ipv6_addr

    @property
    def fqdn(self) -> str:
        """Gets the fqdn of this InterfaceDescription.

        Fully Qualified Domain Name  # noqa: E501

        :return: The fqdn of this InterfaceDescription.
        :rtype: str
        """
        return self._fqdn

    @fqdn.setter
    def fqdn(self, fqdn: str):
        """Sets the fqdn of this InterfaceDescription.

        Fully Qualified Domain Name  # noqa: E501

        :param fqdn: The fqdn of this InterfaceDescription.
        :type fqdn: str
        """
        if fqdn is not None and len(fqdn) > 253:
            raise ValueError("Invalid value for `fqdn`, length must be less than or equal to `253`")  # noqa: E501
        if fqdn is not None and len(fqdn) < 4:
            raise ValueError("Invalid value for `fqdn`, length must be greater than or equal to `4`")  # noqa: E501
        if fqdn is not None and not re.search(r'^([0-9A-Za-z]([-0-9A-Za-z]{0,61}[0-9A-Za-z])?\.)+[A-Za-z]{2,63}\.?$', fqdn):  # noqa: E501
            raise ValueError(r"Invalid value for `fqdn`, must be a follow pattern or equal to `/^([0-9A-Za-z]([-0-9A-Za-z]{0,61}[0-9A-Za-z])?\.)+[A-Za-z]{2,63}\.?$/`")  # noqa: E501

        self._fqdn = fqdn

    @property
    def port(self) -> int:
        """Gets the port of this InterfaceDescription.

        Unsigned integer with valid values between 0 and 65535.  # noqa: E501

        :return: The port of this InterfaceDescription.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port: int):
        """Sets the port of this InterfaceDescription.

        Unsigned integer with valid values between 0 and 65535.  # noqa: E501

        :param port: The port of this InterfaceDescription.
        :type port: int
        """
        if port is not None and port > 65535:  # noqa: E501
            raise ValueError("Invalid value for `port`, must be a value less than or equal to `65535`")  # noqa: E501
        if port is not None and port < 0:  # noqa: E501
            raise ValueError("Invalid value for `port`, must be a value greater than or equal to `0`")  # noqa: E501

        self._port = port

    @property
    def api_prefix(self) -> str:
        """Gets the api_prefix of this InterfaceDescription.

        A string representing a sequence of path segments that starts with the slash character.   # noqa: E501

        :return: The api_prefix of this InterfaceDescription.
        :rtype: str
        """
        return self._api_prefix

    @api_prefix.setter
    def api_prefix(self, api_prefix: str):
        """Sets the api_prefix of this InterfaceDescription.

        A string representing a sequence of path segments that starts with the slash character.   # noqa: E501

        :param api_prefix: The api_prefix of this InterfaceDescription.
        :type api_prefix: str
        """

        self._api_prefix = api_prefix

    @property
    def security_methods(self) -> List[SecurityMethod]:
        """Gets the security_methods of this InterfaceDescription.

        Security methods supported by the interface, it take precedence over the security methods provided in AefProfile, for this specific interface.   # noqa: E501

        :return: The security_methods of this InterfaceDescription.
        :rtype: List[SecurityMethod]
        """
        return self._security_methods

    @security_methods.setter
    def security_methods(self, security_methods: List[SecurityMethod]):
        """Sets the security_methods of this InterfaceDescription.

        Security methods supported by the interface, it take precedence over the security methods provided in AefProfile, for this specific interface.   # noqa: E501

        :param security_methods: The security_methods of this InterfaceDescription.
        :type security_methods: List[SecurityMethod]
        """
        if security_methods is not None and len(security_methods) < 1:
            raise ValueError("Invalid value for `security_methods`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._security_methods = security_methods

    @property
    def grant_types(self) -> List[OAuthGrantType]:
        """Gets the grant_types of this InterfaceDescription.


        :return: The grant_types of this InterfaceDescription.
        :rtype: List[OAuthGrantType]
        """
        return self._grant_types

    @grant_types.setter
    def grant_types(self, grant_types: List[OAuthGrantType]):
        """Sets the grant_types of this InterfaceDescription.


        :param grant_types: The grant_types of this InterfaceDescription.
        :type grant_types: List[OAuthGrantType]
        """
        if grant_types is not None and len(grant_types) < 1:
            raise ValueError("Invalid value for `grant_types`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._grant_types = grant_types
