from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from service_apis.models.base_model import Model
from service_apis.models.service_api_description import ServiceAPIDescription
import re
from service_apis import util

from service_apis.models.service_api_description import ServiceAPIDescription  # noqa: E501
import re  # noqa: E501

class DiscoveredAPIs(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, service_api_descriptions=None, supp_feat=None):  # noqa: E501
        """DiscoveredAPIs - a model defined in OpenAPI

        :param service_api_descriptions: The service_api_descriptions of this DiscoveredAPIs.  # noqa: E501
        :type service_api_descriptions: List[ServiceAPIDescription]
        :param supp_feat: The supp_feat of this DiscoveredAPIs.  # noqa: E501
        :type supp_feat: str
        """
        self.openapi_types = {
            'service_api_descriptions': List[ServiceAPIDescription],
            'supp_feat': str
        }

        self.attribute_map = {
            'service_api_descriptions': 'serviceAPIDescriptions',
            'supp_feat': 'suppFeat'
        }

        self._service_api_descriptions = service_api_descriptions
        self._supp_feat = supp_feat

    @classmethod
    def from_dict(cls, dikt) -> 'DiscoveredAPIs':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The DiscoveredAPIs of this DiscoveredAPIs.  # noqa: E501
        :rtype: DiscoveredAPIs
        """
        return util.deserialize_model(dikt, cls)

    @property
    def service_api_descriptions(self) -> List[ServiceAPIDescription]:
        """Gets the service_api_descriptions of this DiscoveredAPIs.

        Description of the service API as published by the service. Each service API information shall include AEF profiles matching the filter criteria.   # noqa: E501

        :return: The service_api_descriptions of this DiscoveredAPIs.
        :rtype: List[ServiceAPIDescription]
        """
        return self._service_api_descriptions

    @service_api_descriptions.setter
    def service_api_descriptions(self, service_api_descriptions: List[ServiceAPIDescription]):
        """Sets the service_api_descriptions of this DiscoveredAPIs.

        Description of the service API as published by the service. Each service API information shall include AEF profiles matching the filter criteria.   # noqa: E501

        :param service_api_descriptions: The service_api_descriptions of this DiscoveredAPIs.
        :type service_api_descriptions: List[ServiceAPIDescription]
        """
        if service_api_descriptions is not None and len(service_api_descriptions) < 1:
            raise ValueError("Invalid value for `service_api_descriptions`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._service_api_descriptions = service_api_descriptions

    @property
    def supp_feat(self) -> str:
        """Gets the supp_feat of this DiscoveredAPIs.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :return: The supp_feat of this DiscoveredAPIs.
        :rtype: str
        """
        return self._supp_feat

    @supp_feat.setter
    def supp_feat(self, supp_feat: str):
        """Sets the supp_feat of this DiscoveredAPIs.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :param supp_feat: The supp_feat of this DiscoveredAPIs.
        :type supp_feat: str
        """
        if supp_feat is not None and not re.search(r'^[A-Fa-f0-9]*$', supp_feat):  # noqa: E501
            raise ValueError(r"Invalid value for `supp_feat`, must be a follow pattern or equal to `/^[A-Fa-f0-9]*$/`")  # noqa: E501

        self._supp_feat = supp_feat
