import re  # noqa: E501
from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from capif_events import util
from capif_events.models.aef_profile import AefProfile  # noqa: E501
from capif_events.models.api_status import ApiStatus  # noqa: E501
from capif_events.models.base_model import Model
from capif_events.models.published_api_path import PublishedApiPath  # noqa: E501
from capif_events.models.shareable_information import ShareableInformation  # noqa: E501


class ServiceAPIDescription(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, api_name=None, api_id=None, api_status=None, aef_profiles=None, description=None, supported_features=None, shareable_info=None, service_api_category=None, api_supp_feats=None, pub_api_path=None, ccf_id=None, api_prov_name=None):  # noqa: E501
        """ServiceAPIDescription - a model defined in OpenAPI

        :param api_name: The api_name of this ServiceAPIDescription.  # noqa: E501
        :type api_name: str
        :param api_id: The api_id of this ServiceAPIDescription.  # noqa: E501
        :type api_id: str
        :param api_status: The api_status of this ServiceAPIDescription.  # noqa: E501
        :type api_status: ApiStatus
        :param aef_profiles: The aef_profiles of this ServiceAPIDescription.  # noqa: E501
        :type aef_profiles: List[AefProfile]
        :param description: The description of this ServiceAPIDescription.  # noqa: E501
        :type description: str
        :param supported_features: The supported_features of this ServiceAPIDescription.  # noqa: E501
        :type supported_features: str
        :param shareable_info: The shareable_info of this ServiceAPIDescription.  # noqa: E501
        :type shareable_info: ShareableInformation
        :param service_api_category: The service_api_category of this ServiceAPIDescription.  # noqa: E501
        :type service_api_category: str
        :param api_supp_feats: The api_supp_feats of this ServiceAPIDescription.  # noqa: E501
        :type api_supp_feats: str
        :param pub_api_path: The pub_api_path of this ServiceAPIDescription.  # noqa: E501
        :type pub_api_path: PublishedApiPath
        :param ccf_id: The ccf_id of this ServiceAPIDescription.  # noqa: E501
        :type ccf_id: str
        :param api_prov_name: The api_prov_name of this ServiceAPIDescription.  # noqa: E501
        :type api_prov_name: str
        """
        self.openapi_types = {
            'api_name': str,
            'api_id': str,
            'api_status': ApiStatus,
            'aef_profiles': List[AefProfile],
            'description': str,
            'supported_features': str,
            'shareable_info': ShareableInformation,
            'service_api_category': str,
            'api_supp_feats': str,
            'pub_api_path': PublishedApiPath,
            'ccf_id': str,
            'api_prov_name': str
        }

        self.attribute_map = {
            'api_name': 'apiName',
            'api_id': 'apiId',
            'api_status': 'apiStatus',
            'aef_profiles': 'aefProfiles',
            'description': 'description',
            'supported_features': 'supportedFeatures',
            'shareable_info': 'shareableInfo',
            'service_api_category': 'serviceAPICategory',
            'api_supp_feats': 'apiSuppFeats',
            'pub_api_path': 'pubApiPath',
            'ccf_id': 'ccfId',
            'api_prov_name': 'apiProvName'
        }

        self._api_name = api_name
        self._api_id = api_id
        self._api_status = api_status
        self._aef_profiles = aef_profiles
        self._description = description
        self._supported_features = supported_features
        self._shareable_info = shareable_info
        self._service_api_category = service_api_category
        self._api_supp_feats = api_supp_feats
        self._pub_api_path = pub_api_path
        self._ccf_id = ccf_id
        self._api_prov_name = api_prov_name

    @classmethod
    def from_dict(cls, dikt) -> 'ServiceAPIDescription':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ServiceAPIDescription of this ServiceAPIDescription.  # noqa: E501
        :rtype: ServiceAPIDescription
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api_name(self) -> str:
        """Gets the api_name of this ServiceAPIDescription.

        API name, it is set as {apiName} part of the URI structure as defined in  clause 5.2.4 of 3GPP TS 29.122.   # noqa: E501

        :return: The api_name of this ServiceAPIDescription.
        :rtype: str
        """
        return self._api_name

    @api_name.setter
    def api_name(self, api_name: str):
        """Sets the api_name of this ServiceAPIDescription.

        API name, it is set as {apiName} part of the URI structure as defined in  clause 5.2.4 of 3GPP TS 29.122.   # noqa: E501

        :param api_name: The api_name of this ServiceAPIDescription.
        :type api_name: str
        """
        if api_name is None:
            raise ValueError("Invalid value for `api_name`, must not be `None`")  # noqa: E501

        self._api_name = api_name

    @property
    def api_id(self) -> str:
        """Gets the api_id of this ServiceAPIDescription.

        API identifier assigned by the CAPIF core function to the published service API. Shall not be present in the HTTP POST request from the API publishing function to the CAPIF core function. Shall be present in the HTTP POST response from the CAPIF core function to the API publishing function and in the HTTP GET response from the CAPIF core function to the API invoker (discovery API).   # noqa: E501

        :return: The api_id of this ServiceAPIDescription.
        :rtype: str
        """
        return self._api_id

    @api_id.setter
    def api_id(self, api_id: str):
        """Sets the api_id of this ServiceAPIDescription.

        API identifier assigned by the CAPIF core function to the published service API. Shall not be present in the HTTP POST request from the API publishing function to the CAPIF core function. Shall be present in the HTTP POST response from the CAPIF core function to the API publishing function and in the HTTP GET response from the CAPIF core function to the API invoker (discovery API).   # noqa: E501

        :param api_id: The api_id of this ServiceAPIDescription.
        :type api_id: str
        """

        self._api_id = api_id

    @property
    def api_status(self) -> ApiStatus:
        """Gets the api_status of this ServiceAPIDescription.


        :return: The api_status of this ServiceAPIDescription.
        :rtype: ApiStatus
        """
        return self._api_status

    @api_status.setter
    def api_status(self, api_status: ApiStatus):
        """Sets the api_status of this ServiceAPIDescription.


        :param api_status: The api_status of this ServiceAPIDescription.
        :type api_status: ApiStatus
        """

        self._api_status = api_status

    @property
    def aef_profiles(self) -> List[AefProfile]:
        """Gets the aef_profiles of this ServiceAPIDescription.

        AEF profile information, which includes the exposed API details (e.g. protocol).   # noqa: E501

        :return: The aef_profiles of this ServiceAPIDescription.
        :rtype: List[AefProfile]
        """
        return self._aef_profiles

    @aef_profiles.setter
    def aef_profiles(self, aef_profiles: List[AefProfile]):
        """Sets the aef_profiles of this ServiceAPIDescription.

        AEF profile information, which includes the exposed API details (e.g. protocol).   # noqa: E501

        :param aef_profiles: The aef_profiles of this ServiceAPIDescription.
        :type aef_profiles: List[AefProfile]
        """
        if aef_profiles is not None and len(aef_profiles) < 1:
            raise ValueError("Invalid value for `aef_profiles`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._aef_profiles = aef_profiles

    @property
    def description(self) -> str:
        """Gets the description of this ServiceAPIDescription.

        Text description of the API  # noqa: E501

        :return: The description of this ServiceAPIDescription.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str):
        """Sets the description of this ServiceAPIDescription.

        Text description of the API  # noqa: E501

        :param description: The description of this ServiceAPIDescription.
        :type description: str
        """

        self._description = description

    @property
    def supported_features(self) -> str:
        """Gets the supported_features of this ServiceAPIDescription.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :return: The supported_features of this ServiceAPIDescription.
        :rtype: str
        """
        return self._supported_features

    @supported_features.setter
    def supported_features(self, supported_features: str):
        """Sets the supported_features of this ServiceAPIDescription.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :param supported_features: The supported_features of this ServiceAPIDescription.
        :type supported_features: str
        """
        if supported_features is not None and not re.search(r'^[A-Fa-f0-9]*$', supported_features):  # noqa: E501
            raise ValueError("Invalid value for `supported_features`, must be a follow pattern or equal to `/^[A-Fa-f0-9]*$/`")  # noqa: E501

        self._supported_features = supported_features

    @property
    def shareable_info(self) -> ShareableInformation:
        """Gets the shareable_info of this ServiceAPIDescription.


        :return: The shareable_info of this ServiceAPIDescription.
        :rtype: ShareableInformation
        """
        return self._shareable_info

    @shareable_info.setter
    def shareable_info(self, shareable_info: ShareableInformation):
        """Sets the shareable_info of this ServiceAPIDescription.


        :param shareable_info: The shareable_info of this ServiceAPIDescription.
        :type shareable_info: ShareableInformation
        """

        self._shareable_info = shareable_info

    @property
    def service_api_category(self) -> str:
        """Gets the service_api_category of this ServiceAPIDescription.

        The service API category to which the service API belongs to.  # noqa: E501

        :return: The service_api_category of this ServiceAPIDescription.
        :rtype: str
        """
        return self._service_api_category

    @service_api_category.setter
    def service_api_category(self, service_api_category: str):
        """Sets the service_api_category of this ServiceAPIDescription.

        The service API category to which the service API belongs to.  # noqa: E501

        :param service_api_category: The service_api_category of this ServiceAPIDescription.
        :type service_api_category: str
        """

        self._service_api_category = service_api_category

    @property
    def api_supp_feats(self) -> str:
        """Gets the api_supp_feats of this ServiceAPIDescription.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :return: The api_supp_feats of this ServiceAPIDescription.
        :rtype: str
        """
        return self._api_supp_feats

    @api_supp_feats.setter
    def api_supp_feats(self, api_supp_feats: str):
        """Sets the api_supp_feats of this ServiceAPIDescription.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :param api_supp_feats: The api_supp_feats of this ServiceAPIDescription.
        :type api_supp_feats: str
        """
        if api_supp_feats is not None and not re.search(r'^[A-Fa-f0-9]*$', api_supp_feats):  # noqa: E501
            raise ValueError("Invalid value for `api_supp_feats`, must be a follow pattern or equal to `/^[A-Fa-f0-9]*$/`")  # noqa: E501

        self._api_supp_feats = api_supp_feats

    @property
    def pub_api_path(self) -> PublishedApiPath:
        """Gets the pub_api_path of this ServiceAPIDescription.


        :return: The pub_api_path of this ServiceAPIDescription.
        :rtype: PublishedApiPath
        """
        return self._pub_api_path

    @pub_api_path.setter
    def pub_api_path(self, pub_api_path: PublishedApiPath):
        """Sets the pub_api_path of this ServiceAPIDescription.


        :param pub_api_path: The pub_api_path of this ServiceAPIDescription.
        :type pub_api_path: PublishedApiPath
        """

        self._pub_api_path = pub_api_path

    @property
    def ccf_id(self) -> str:
        """Gets the ccf_id of this ServiceAPIDescription.

        CAPIF core function identifier.  # noqa: E501

        :return: The ccf_id of this ServiceAPIDescription.
        :rtype: str
        """
        return self._ccf_id

    @ccf_id.setter
    def ccf_id(self, ccf_id: str):
        """Sets the ccf_id of this ServiceAPIDescription.

        CAPIF core function identifier.  # noqa: E501

        :param ccf_id: The ccf_id of this ServiceAPIDescription.
        :type ccf_id: str
        """

        self._ccf_id = ccf_id

    @property
    def api_prov_name(self) -> str:
        """Gets the api_prov_name of this ServiceAPIDescription.

        Represents the API provider name.  # noqa: E501

        :return: The api_prov_name of this ServiceAPIDescription.
        :rtype: str
        """
        return self._api_prov_name

    @api_prov_name.setter
    def api_prov_name(self, api_prov_name: str):
        """Sets the api_prov_name of this ServiceAPIDescription.

        Represents the API provider name.  # noqa: E501

        :param api_prov_name: The api_prov_name of this ServiceAPIDescription.
        :type api_prov_name: str
        """

        self._api_prov_name = api_prov_name
