from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from api_invoker_management.models.base_model import Model
from api_invoker_management.models.api_list import APIList
from api_invoker_management.models.onboarding_information import OnboardingInformation
from api_invoker_management.models.websock_notif_config import WebsockNotifConfig
import re
from api_invoker_management import util

from api_invoker_management.models.api_list import APIList  # noqa: E501
from api_invoker_management.models.onboarding_information import OnboardingInformation  # noqa: E501
from api_invoker_management.models.websock_notif_config import WebsockNotifConfig  # noqa: E501
import re  # noqa: E501

class APIInvokerEnrolmentDetails(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, api_invoker_id=None, onboarding_information=None, notification_destination=None, request_test_notification=None, websock_notif_config=None, api_list=None, api_invoker_information=None, exp_time=None, supported_features=None):  # noqa: E501
        """APIInvokerEnrolmentDetails - a model defined in OpenAPI

        :param api_invoker_id: The api_invoker_id of this APIInvokerEnrolmentDetails.  # noqa: E501
        :type api_invoker_id: str
        :param onboarding_information: The onboarding_information of this APIInvokerEnrolmentDetails.  # noqa: E501
        :type onboarding_information: OnboardingInformation
        :param notification_destination: The notification_destination of this APIInvokerEnrolmentDetails.  # noqa: E501
        :type notification_destination: str
        :param request_test_notification: The request_test_notification of this APIInvokerEnrolmentDetails.  # noqa: E501
        :type request_test_notification: bool
        :param websock_notif_config: The websock_notif_config of this APIInvokerEnrolmentDetails.  # noqa: E501
        :type websock_notif_config: WebsockNotifConfig
        :param api_list: The api_list of this APIInvokerEnrolmentDetails.  # noqa: E501
        :type api_list: APIList
        :param api_invoker_information: The api_invoker_information of this APIInvokerEnrolmentDetails.  # noqa: E501
        :type api_invoker_information: str
        :param exp_time: The exp_time of this APIInvokerEnrolmentDetails.  # noqa: E501
        :type exp_time: datetime
        :param supported_features: The supported_features of this APIInvokerEnrolmentDetails.  # noqa: E501
        :type supported_features: str
        """
        self.openapi_types = {
            'api_invoker_id': str,
            'onboarding_information': OnboardingInformation,
            'notification_destination': str,
            'request_test_notification': bool,
            'websock_notif_config': WebsockNotifConfig,
            'api_list': APIList,
            'api_invoker_information': str,
            'exp_time': datetime,
            'supported_features': str
        }

        self.attribute_map = {
            'api_invoker_id': 'apiInvokerId',
            'onboarding_information': 'onboardingInformation',
            'notification_destination': 'notificationDestination',
            'request_test_notification': 'requestTestNotification',
            'websock_notif_config': 'websockNotifConfig',
            'api_list': 'apiList',
            'api_invoker_information': 'apiInvokerInformation',
            'exp_time': 'expTime',
            'supported_features': 'supportedFeatures'
        }

        self._api_invoker_id = api_invoker_id
        self._onboarding_information = onboarding_information
        self._notification_destination = notification_destination
        self._request_test_notification = request_test_notification
        self._websock_notif_config = websock_notif_config
        self._api_list = api_list
        self._api_invoker_information = api_invoker_information
        self._exp_time = exp_time
        self._supported_features = supported_features

    @classmethod
    def from_dict(cls, dikt) -> 'APIInvokerEnrolmentDetails':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The APIInvokerEnrolmentDetails of this APIInvokerEnrolmentDetails.  # noqa: E501
        :rtype: APIInvokerEnrolmentDetails
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api_invoker_id(self) -> str:
        """Gets the api_invoker_id of this APIInvokerEnrolmentDetails.

        API invoker ID assigned by the CAPIF core function to the API invoker while on-boarding the API invoker. Shall not be present in the HTTP POST request from the API invoker to the CAPIF core function, to on-board itself. Shall be present in all other HTTP requests and responses.   # noqa: E501

        :return: The api_invoker_id of this APIInvokerEnrolmentDetails.
        :rtype: str
        """
        return self._api_invoker_id

    @api_invoker_id.setter
    def api_invoker_id(self, api_invoker_id: str):
        """Sets the api_invoker_id of this APIInvokerEnrolmentDetails.

        API invoker ID assigned by the CAPIF core function to the API invoker while on-boarding the API invoker. Shall not be present in the HTTP POST request from the API invoker to the CAPIF core function, to on-board itself. Shall be present in all other HTTP requests and responses.   # noqa: E501

        :param api_invoker_id: The api_invoker_id of this APIInvokerEnrolmentDetails.
        :type api_invoker_id: str
        """

        self._api_invoker_id = api_invoker_id

    @property
    def onboarding_information(self) -> OnboardingInformation:
        """Gets the onboarding_information of this APIInvokerEnrolmentDetails.


        :return: The onboarding_information of this APIInvokerEnrolmentDetails.
        :rtype: OnboardingInformation
        """
        return self._onboarding_information

    @onboarding_information.setter
    def onboarding_information(self, onboarding_information: OnboardingInformation):
        """Sets the onboarding_information of this APIInvokerEnrolmentDetails.


        :param onboarding_information: The onboarding_information of this APIInvokerEnrolmentDetails.
        :type onboarding_information: OnboardingInformation
        """
        if onboarding_information is None:
            raise ValueError("Invalid value for `onboarding_information`, must not be `None`")  # noqa: E501

        self._onboarding_information = onboarding_information

    @property
    def notification_destination(self) -> str:
        """Gets the notification_destination of this APIInvokerEnrolmentDetails.

        string providing an URI formatted according to IETF RFC 3986.  # noqa: E501

        :return: The notification_destination of this APIInvokerEnrolmentDetails.
        :rtype: str
        """
        return self._notification_destination

    @notification_destination.setter
    def notification_destination(self, notification_destination: str):
        """Sets the notification_destination of this APIInvokerEnrolmentDetails.

        string providing an URI formatted according to IETF RFC 3986.  # noqa: E501

        :param notification_destination: The notification_destination of this APIInvokerEnrolmentDetails.
        :type notification_destination: str
        """
        if notification_destination is None:
            raise ValueError("Invalid value for `notification_destination`, must not be `None`")  # noqa: E501

        self._notification_destination = notification_destination

    @property
    def request_test_notification(self) -> bool:
        """Gets the request_test_notification of this APIInvokerEnrolmentDetails.

        Set to true by Subscriber to request the CAPIF core function to send a test notification as defined in in clause 7.6. Set to false or omitted otherwise.   # noqa: E501

        :return: The request_test_notification of this APIInvokerEnrolmentDetails.
        :rtype: bool
        """
        return self._request_test_notification

    @request_test_notification.setter
    def request_test_notification(self, request_test_notification: bool):
        """Sets the request_test_notification of this APIInvokerEnrolmentDetails.

        Set to true by Subscriber to request the CAPIF core function to send a test notification as defined in in clause 7.6. Set to false or omitted otherwise.   # noqa: E501

        :param request_test_notification: The request_test_notification of this APIInvokerEnrolmentDetails.
        :type request_test_notification: bool
        """

        self._request_test_notification = request_test_notification

    @property
    def websock_notif_config(self) -> WebsockNotifConfig:
        """Gets the websock_notif_config of this APIInvokerEnrolmentDetails.


        :return: The websock_notif_config of this APIInvokerEnrolmentDetails.
        :rtype: WebsockNotifConfig
        """
        return self._websock_notif_config

    @websock_notif_config.setter
    def websock_notif_config(self, websock_notif_config: WebsockNotifConfig):
        """Sets the websock_notif_config of this APIInvokerEnrolmentDetails.


        :param websock_notif_config: The websock_notif_config of this APIInvokerEnrolmentDetails.
        :type websock_notif_config: WebsockNotifConfig
        """

        self._websock_notif_config = websock_notif_config

    @property
    def api_list(self) -> APIList:
        """Gets the api_list of this APIInvokerEnrolmentDetails.


        :return: The api_list of this APIInvokerEnrolmentDetails.
        :rtype: APIList
        """
        return self._api_list

    @api_list.setter
    def api_list(self, api_list: APIList):
        """Sets the api_list of this APIInvokerEnrolmentDetails.


        :param api_list: The api_list of this APIInvokerEnrolmentDetails.
        :type api_list: APIList
        """

        self._api_list = api_list

    @property
    def api_invoker_information(self) -> str:
        """Gets the api_invoker_information of this APIInvokerEnrolmentDetails.

        Generic information related to the API invoker such as details of the device or the application.   # noqa: E501

        :return: The api_invoker_information of this APIInvokerEnrolmentDetails.
        :rtype: str
        """
        return self._api_invoker_information

    @api_invoker_information.setter
    def api_invoker_information(self, api_invoker_information: str):
        """Sets the api_invoker_information of this APIInvokerEnrolmentDetails.

        Generic information related to the API invoker such as details of the device or the application.   # noqa: E501

        :param api_invoker_information: The api_invoker_information of this APIInvokerEnrolmentDetails.
        :type api_invoker_information: str
        """

        self._api_invoker_information = api_invoker_information

    @property
    def exp_time(self) -> datetime:
        """Gets the exp_time of this APIInvokerEnrolmentDetails.

        string with format \"date-time\" as defined in OpenAPI.  # noqa: E501

        :return: The exp_time of this APIInvokerEnrolmentDetails.
        :rtype: datetime
        """
        return self._exp_time

    @exp_time.setter
    def exp_time(self, exp_time: datetime):
        """Sets the exp_time of this APIInvokerEnrolmentDetails.

        string with format \"date-time\" as defined in OpenAPI.  # noqa: E501

        :param exp_time: The exp_time of this APIInvokerEnrolmentDetails.
        :type exp_time: datetime
        """

        self._exp_time = exp_time

    @property
    def supported_features(self) -> str:
        """Gets the supported_features of this APIInvokerEnrolmentDetails.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :return: The supported_features of this APIInvokerEnrolmentDetails.
        :rtype: str
        """
        return self._supported_features

    @supported_features.setter
    def supported_features(self, supported_features: str):
        """Sets the supported_features of this APIInvokerEnrolmentDetails.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :param supported_features: The supported_features of this APIInvokerEnrolmentDetails.
        :type supported_features: str
        """
        if supported_features is not None and not re.search(r'^[A-Fa-f0-9]*$', supported_features):  # noqa: E501
            raise ValueError("Invalid value for `supported_features`, must be a follow pattern or equal to `/^[A-Fa-f0-9]*$/`")  # noqa: E501

        self._supported_features = supported_features
