# Install CAPIF in Kubernetes using HELM

## Dependencies
- Helm
-  `Ingress` already in cluster (if configured in capif - `values.yaml`)
  - ```
    # OPTIONAL - if not exists Ingress in cluster, use this command to install it
    $ helm upgrade --install ingress-nginx ingress-nginx --repo https://kubernetes.github.io/ingress-nginx --set rbac.create=true --set controller.service.type=NodePort

    # OPTIONAL - if you need specify the nodePort in cluster use
    $ helm upgrade --install ingress-nginx ingress-nginx --repo https://kubernetes.github.io/ingress-nginx --set rbac.create=true --set controller.service.type=NodePort --set controller.service.nodePorts.http=32080 --set controller.service.nodePorts.https=32443 --namespace ingress-nginx --create-namespace --set controller.extraArgs."enable-ssl-passthrough=true" --kubeconfig ../oneke-new.kubeconfig 

    # Check if ssl-passthrough is enabled in nginx controller.
    $ kubectl -n ingress-nginx get deploy -o yaml | grep passthrough
    ```
-  `PersistentVolumeClain` already in cluster (if configured in capif)

## Considerations before to install/deploy:
- **Prometheus**: 
    - You can install prometheus but you will need permissions to deploy prometheus in the cluster. The helm creates a ClusterRole to access to all resources in the cluster. 
    - If you don't have permission or there is already provided a Prometheus
      in the cluster. in `capif/values.yaml` gives the field `monitoring.prometheus.enable: ""`
        - Grafana will need the endpoint to prometheus. Please keep in mind setup the grafana's field in `capif/values.yaml`
- **Vault**:
    - You will need a instance of vault already deployed. If the cluster doesn't provide the vault instance. You can install it following the next [steps](https://github.com/Telefonica/CAPIF_Future_Network_Lab/blob/main/helm/README-vault.md)
    - Once the vault is provided in the cluster. You need to create the PKI and certificates. Follow the vault-job [step](https://github.com/Telefonica/CAPIF_Future_Network_Lab/blob/main/helm/README-vault.md#creating-vault-pki-and-certificates) to create it
        - Setup the `parametersVault.env.VaultHostname`: This is the endPoint to vault. This endpoint can be a service/ingress of kubernetes
        - Setup `parametersVault.env.VaultPort`: This is the port listenting to vault instance
        - Setup `parametersVault.env.vaultAccessToken`: This is the token used for capif to create the certificates in vault. If vault owns of you. Use the token created in [Vault readme](https://github.com/Telefonica/CAPIF_Future_Network_Lab/blob/main/helm/README-vault.md#creating-vault-pki-and-certificates) . Otherwise, the admin
        of the cluster will provide you the token. This token will need sufficient permissions to create PKI and certificates.
- **CAPIF**
    - Please, have a look of [`values.yaml`](https://github.com/Telefonica/CAPIF_Future_Network_Lab/blob/main/helm/capif/values.yaml) file and setup according to the conditions
 ```
 # download dependencies 
 $ helm dependency build capif/

# check ingress_ip.oneke
kubectl get svc -A | grep nginx

# install capif
$ helm upgrade --install -n mon monitoring-capif capif/ --set nginx.nginx.env.capifHostname=mon-capif.monitoring.int --set ingress_ip.oneke="10.17.173.127" --atomic --create-namespace
 ```

NOTA: The deployment can take until 8 minutes to be ready. Please, if it fails, re-install CAPIF

## Troubleshooting
- [`Mongo stuck`](https://www.ibm.com/docs/en/cloud-paks/cp-biz-automation/20.0.x?topic=troubleshooting-mongodb-pod-fails-start-container-exit-code-14-100)
