#!/bin/bash

help() {
  echo "Usage: $1 <options>"
  echo "       -i : Setup different host ip for mock server (default 0.0.0.0)"
  echo "       -p : Setup different port for mock server (default 9090)"
  echo "       -h : show this help"
  exit 1
}

cd ..
REPOSITORY_BASE_FOLDER=${PWD}
MOCK_SERVER_FOLDER=${PWD}/tests/libraries/mock_server

IP=0.0.0.0
PORT=9090

# Read params
while getopts ":i:p:h" opt; do
  case $opt in
    i)
      IP="$OPTARG"
      ;;
    p)
      PORT=$OPTARG
      ;;
    h)
      help
      ;;  
    \?)
      echo "Not valid option: -$OPTARG" >&2
      help
      ;;
    :)
      echo "The -$OPTARG option requires an argument." >&2
      help
      ;;
  esac
done

echo Robot Framework Mock Server will listen on $IP:$PORT
pip install -r ${MOCK_SERVER_FOLDER}/requirements.txt

IP=$IP PORT=$PORT python ${MOCK_SERVER_FOLDER}/mock_server.py
