from ..encoder import JSONEncoder
from .publisher import Publisher
import json

publisher_ops = Publisher()

class RedisEvent():
    def __init__(self, event, information, event_detail_key) -> None:
        self.redis_event={
            "event": event,
            "key": event_detail_key,
            "information":information
        }
    
    def to_string(self):
        return json.dumps(self.redis_event, cls=JSONEncoder)
    
    def send_event(self):
        publisher_ops.publish_message("events-log",self.to_string())
    
    def __call__(self):
        return self.redis_event